(ns
 com.palletops.awaze.directconnect
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.directconnect :as directconnect]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :directconnect
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.directconnect.AmazonDirectConnectClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.RouteFilterPrefix}
route-filter-prefix
  [m3853]
  (clojure.core/let
   [bean3852
    (new com.amazonaws.services.directconnect.model.RouteFilterPrefix)]
   (clojure.core/when-let
    [v3854 (:cidr m3853)]
    (. bean3852 setCidr (clojure.core/str v3854)))
   bean3852))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterface}
new-public-virtual-interface
  [m3856]
  (clojure.core/let
   [bean3855
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterface)]
   (clojure.core/when-let
    [v3857 (:vlan m3856)]
    (. bean3855 setVlan (clojure.core/int v3857)))
   (clojure.core/when-let
    [v3857 (:virtual-interface-name m3856)]
    (. bean3855 setVirtualInterfaceName (clojure.core/str v3857)))
   (clojure.core/when-let
    [v3857 (:asn m3856)]
    (. bean3855 setAsn (clojure.core/int v3857)))
   (clojure.core/when-let
    [v3857 (:auth-key m3856)]
    (. bean3855 setAuthKey (clojure.core/str v3857)))
   (clojure.core/when-let
    [v3857 (:amazon-address m3856)]
    (. bean3855 setAmazonAddress (clojure.core/str v3857)))
   (clojure.core/when-let
    [v3857 (:customer-address m3856)]
    (. bean3855 setCustomerAddress (clojure.core/str v3857)))
   (clojure.core/when-let
    [v3857 (:route-filter-prefixes m3856)]
    (.
     bean3855
     setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg3924]
  (directconnect/route-filter-prefix arg3924))
 v3857)))
   bean3855))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface}
new-private-virtual-interface
  [m3859]
  (clojure.core/let
   [bean3858
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface)]
   (clojure.core/when-let
    [v3860 (:virtual-gateway-id m3859)]
    (. bean3858 setVirtualGatewayId (clojure.core/str v3860)))
   (clojure.core/when-let
    [v3860 (:vlan m3859)]
    (. bean3858 setVlan (clojure.core/int v3860)))
   (clojure.core/when-let
    [v3860 (:virtual-interface-name m3859)]
    (. bean3858 setVirtualInterfaceName (clojure.core/str v3860)))
   (clojure.core/when-let
    [v3860 (:asn m3859)]
    (. bean3858 setAsn (clojure.core/int v3860)))
   (clojure.core/when-let
    [v3860 (:auth-key m3859)]
    (. bean3858 setAuthKey (clojure.core/str v3860)))
   (clojure.core/when-let
    [v3860 (:amazon-address m3859)]
    (. bean3858 setAmazonAddress (clojure.core/str v3860)))
   (clojure.core/when-let
    [v3860 (:customer-address m3859)]
    (. bean3858 setCustomerAddress (clojure.core/str v3860)))
   bean3858))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation}
new-private-virtual-interface-allocation
  [m3862]
  (clojure.core/let
   [bean3861
    (new
     com.amazonaws.services.directconnect.model.NewPrivateVirtualInterfaceAllocation)]
   (clojure.core/when-let
    [v3863 (:vlan m3862)]
    (. bean3861 setVlan (clojure.core/int v3863)))
   (clojure.core/when-let
    [v3863 (:virtual-interface-name m3862)]
    (. bean3861 setVirtualInterfaceName (clojure.core/str v3863)))
   (clojure.core/when-let
    [v3863 (:asn m3862)]
    (. bean3861 setAsn (clojure.core/int v3863)))
   (clojure.core/when-let
    [v3863 (:auth-key m3862)]
    (. bean3861 setAuthKey (clojure.core/str v3863)))
   (clojure.core/when-let
    [v3863 (:amazon-address m3862)]
    (. bean3861 setAmazonAddress (clojure.core/str v3863)))
   (clojure.core/when-let
    [v3863 (:customer-address m3862)]
    (. bean3861 setCustomerAddress (clojure.core/str v3863)))
   bean3861))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation}
new-public-virtual-interface-allocation
  [m3865]
  (clojure.core/let
   [bean3864
    (new
     com.amazonaws.services.directconnect.model.NewPublicVirtualInterfaceAllocation)]
   (clojure.core/when-let
    [v3866 (:vlan m3865)]
    (. bean3864 setVlan (clojure.core/int v3866)))
   (clojure.core/when-let
    [v3866 (:virtual-interface-name m3865)]
    (. bean3864 setVirtualInterfaceName (clojure.core/str v3866)))
   (clojure.core/when-let
    [v3866 (:asn m3865)]
    (. bean3864 setAsn (clojure.core/int v3866)))
   (clojure.core/when-let
    [v3866 (:auth-key m3865)]
    (. bean3864 setAuthKey (clojure.core/str v3866)))
   (clojure.core/when-let
    [v3866 (:amazon-address m3865)]
    (. bean3864 setAmazonAddress (clojure.core/str v3866)))
   (clojure.core/when-let
    [v3866 (:customer-address m3865)]
    (. bean3864 setCustomerAddress (clojure.core/str v3866)))
   (clojure.core/when-let
    [v3866 (:route-filter-prefixes m3865)]
    (.
     bean3864
     setRouteFilterPrefixes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn
  [arg3925]
  (directconnect/route-filter-prefix arg3925))
 v3866)))
   bean3864))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteConnectionRequest}
delete-connection-request
  [m3868]
  (clojure.core/let
   [bean3867
    (new
     com.amazonaws.services.directconnect.model.DeleteConnectionRequest)]
   (clojure.core/when-let
    [v3869 (:connection-id m3868)]
    (. bean3867 setConnectionId (clojure.core/str v3869)))
   bean3867))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest}
describe-connections-on-interconnect-request
  [m3871]
  (clojure.core/let
   [bean3870
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest)]
   (clojure.core/when-let
    [v3872 (:interconnect-id m3871)]
    (. bean3870 setInterconnectId (clojure.core/str v3872)))
   bean3870))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeLocationsRequest}
describe-locations-request
  [m3874]
  (clojure.core/let
   [bean3873
    (new
     com.amazonaws.services.directconnect.model.DescribeLocationsRequest)]
   bean3873))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest}
allocate-connection-on-interconnect-request
  [m3877]
  (clojure.core/let
   [bean3876
    (new
     com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest)]
   (clojure.core/when-let
    [v3878 (:owner-account m3877)]
    (. bean3876 setOwnerAccount (clojure.core/str v3878)))
   (clojure.core/when-let
    [v3878 (:interconnect-id m3877)]
    (. bean3876 setInterconnectId (clojure.core/str v3878)))
   (clojure.core/when-let
    [v3878 (:bandwidth m3877)]
    (. bean3876 setBandwidth (clojure.core/str v3878)))
   (clojure.core/when-let
    [v3878 (:connection-name m3877)]
    (. bean3876 setConnectionName (clojure.core/str v3878)))
   (clojure.core/when-let
    [v3878 (:vlan m3877)]
    (. bean3876 setVlan (clojure.core/int v3878)))
   bean3876))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest}
create-public-virtual-interface-request
  [m3880]
  (clojure.core/let
   [bean3879
    (new
     com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3881 (:connection-id m3880)]
    (. bean3879 setConnectionId (clojure.core/str v3881)))
   (clojure.core/when-let
    [v3881 (:new-public-virtual-interface m3880)]
    (.
     bean3879
     setNewPublicVirtualInterface
     (directconnect/new-public-virtual-interface v3881)))
   bean3879))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmConnectionRequest}
confirm-connection-request
  [m3883]
  (clojure.core/let
   [bean3882
    (new
     com.amazonaws.services.directconnect.model.ConfirmConnectionRequest)]
   (clojure.core/when-let
    [v3884 (:connection-id m3883)]
    (. bean3882 setConnectionId (clojure.core/str v3884)))
   bean3882))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest}
confirm-private-virtual-interface-request
  [m3886]
  (clojure.core/let
   [bean3885
    (new
     com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3887 (:virtual-interface-id m3886)]
    (. bean3885 setVirtualInterfaceId (clojure.core/str v3887)))
   (clojure.core/when-let
    [v3887 (:virtual-gateway-id m3886)]
    (. bean3885 setVirtualGatewayId (clojure.core/str v3887)))
   bean3885))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateInterconnectRequest}
create-interconnect-request
  [m3889]
  (clojure.core/let
   [bean3888
    (new
     com.amazonaws.services.directconnect.model.CreateInterconnectRequest)]
   (clojure.core/when-let
    [v3890 (:location m3889)]
    (. bean3888 setLocation (clojure.core/str v3890)))
   (clojure.core/when-let
    [v3890 (:interconnect-name m3889)]
    (. bean3888 setInterconnectName (clojure.core/str v3890)))
   (clojure.core/when-let
    [v3890 (:bandwidth m3889)]
    (. bean3888 setBandwidth (clojure.core/str v3890)))
   bean3888))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest}
confirm-public-virtual-interface-request
  [m3892]
  (clojure.core/let
   [bean3891
    (new
     com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3893 (:virtual-interface-id m3892)]
    (. bean3891 setVirtualInterfaceId (clojure.core/str v3893)))
   bean3891))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest}
delete-virtual-interface-request
  [m3895]
  (clojure.core/let
   [bean3894
    (new
     com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3896 (:virtual-interface-id m3895)]
    (. bean3894 setVirtualInterfaceId (clojure.core/str v3896)))
   bean3894))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest}
create-private-virtual-interface-request
  [m3898]
  (clojure.core/let
   [bean3897
    (new
     com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3899 (:connection-id m3898)]
    (. bean3897 setConnectionId (clojure.core/str v3899)))
   (clojure.core/when-let
    [v3899 (:new-private-virtual-interface m3898)]
    (.
     bean3897
     setNewPrivateVirtualInterface
     (directconnect/new-private-virtual-interface v3899)))
   bean3897))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest}
allocate-private-virtual-interface-request
  [m3901]
  (clojure.core/let
   [bean3900
    (new
     com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3902 (:owner-account m3901)]
    (. bean3900 setOwnerAccount (clojure.core/str v3902)))
   (clojure.core/when-let
    [v3902 (:connection-id m3901)]
    (. bean3900 setConnectionId (clojure.core/str v3902)))
   (clojure.core/when-let
    [v3902 (:new-private-virtual-interface-allocation m3901)]
    (.
     bean3900
     setNewPrivateVirtualInterfaceAllocation
     (directconnect/new-private-virtual-interface-allocation v3902)))
   bean3900))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest}
describe-virtual-interfaces-request
  [m3904]
  (clojure.core/let
   [bean3903
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest)]
   (clojure.core/when-let
    [v3905 (:virtual-interface-id m3904)]
    (. bean3903 setVirtualInterfaceId (clojure.core/str v3905)))
   (clojure.core/when-let
    [v3905 (:connection-id m3904)]
    (. bean3903 setConnectionId (clojure.core/str v3905)))
   bean3903))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeConnectionsRequest}
describe-connections-request
  [m3907]
  (clojure.core/let
   [bean3906
    (new
     com.amazonaws.services.directconnect.model.DescribeConnectionsRequest)]
   (clojure.core/when-let
    [v3908 (:connection-id m3907)]
    (. bean3906 setConnectionId (clojure.core/str v3908)))
   bean3906))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest}
allocate-public-virtual-interface-request
  [m3910]
  (clojure.core/let
   [bean3909
    (new
     com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest)]
   (clojure.core/when-let
    [v3911 (:owner-account m3910)]
    (. bean3909 setOwnerAccount (clojure.core/str v3911)))
   (clojure.core/when-let
    [v3911 (:connection-id m3910)]
    (. bean3909 setConnectionId (clojure.core/str v3911)))
   (clojure.core/when-let
    [v3911 (:new-public-virtual-interface-allocation m3910)]
    (.
     bean3909
     setNewPublicVirtualInterfaceAllocation
     (directconnect/new-public-virtual-interface-allocation v3911)))
   bean3909))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest}
describe-interconnects-request
  [m3913]
  (clojure.core/let
   [bean3912
    (new
     com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest)]
   (clojure.core/when-let
    [v3914 (:interconnect-id m3913)]
    (. bean3912 setInterconnectId (clojure.core/str v3914)))
   bean3912))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.CreateConnectionRequest}
create-connection-request
  [m3916]
  (clojure.core/let
   [bean3915
    (new
     com.amazonaws.services.directconnect.model.CreateConnectionRequest)]
   (clojure.core/when-let
    [v3917 (:location m3916)]
    (. bean3915 setLocation (clojure.core/str v3917)))
   (clojure.core/when-let
    [v3917 (:bandwidth m3916)]
    (. bean3915 setBandwidth (clojure.core/str v3917)))
   (clojure.core/when-let
    [v3917 (:connection-name m3916)]
    (. bean3915 setConnectionName (clojure.core/str v3917)))
   bean3915))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DeleteInterconnectRequest}
delete-interconnect-request
  [m3919]
  (clojure.core/let
   [bean3918
    (new
     com.amazonaws.services.directconnect.model.DeleteInterconnectRequest)]
   (clojure.core/when-let
    [v3920 (:interconnect-id m3919)]
    (. bean3918 setInterconnectId (clojure.core/str v3920)))
   bean3918))
 (clojure.core/defn
^{:tag com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest}
describe-virtual-gateways-request
  [m3922]
  (clojure.core/let
   [bean3921
    (new
     com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest)]
   bean3921))
 (clojure.core/defmulti
  directconnect
  (clojure.core/fn
   directconnect
   [m__1681__auto__]
   (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-connection
   [m3926]
   (clojure.core/let
    [credentials3927 (:credentials m3926) args3928 (:args m3926)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3929
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3927)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3929
       deleteConnection
       (directconnect/delete-connection-request
        (clojure.core/nth args3928 0)))))))
  (clojure.core/defn
   delete-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Generate map for deleteConnection"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :delete-connection,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-connection
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Call deleteConnection"}
   [credentials3931 & args3932]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3933
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3931)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3933
      deleteConnection
      (directconnect/delete-connection-request
       (clojure.core/nth args3932 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections-on-interconnect
   [m3934]
   (clojure.core/let
    [credentials3935 (:credentials m3934) args3936 (:args m3934)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3937
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3935)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3937
       describeConnectionsOnInterconnect
       (directconnect/describe-connections-on-interconnect-request
        (clojure.core/nth args3936 0)))))))
  (clojure.core/defn
   describe-connections-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Generate map for describeConnectionsOnInterconnect"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-connections-on-interconnect,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-connections-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Call describeConnectionsOnInterconnect"}
   [credentials3939 & args3940]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3941
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3939)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3941
      describeConnectionsOnInterconnect
      (directconnect/describe-connections-on-interconnect-request
       (clojure.core/nth args3940 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-locations
   [m3942]
   (clojure.core/let
    [credentials3943 (:credentials m3942) args3944 (:args m3942)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3945
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3943)]
     (clojure.core/case
      (clojure.core/count args3944)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3945
        describeLocations))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3945
        describeLocations
        (directconnect/describe-locations-request
         (clojure.core/nth args3944 0))))))))
  (clojure.core/defn
   describe-locations-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeLocations, describeLocations"}
   ([credentials__1649__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-locations,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-locations,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-locations
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeLocations, describeLocations"}
   [credentials3947 & args3948]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3949
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3947)]
    (clojure.core/case
     (clojure.core/count args3948)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3949
       describeLocations))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3949
       describeLocations
       (directconnect/describe-locations-request
        (clojure.core/nth args3948 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-connection-on-interconnect
   [m3950]
   (clojure.core/let
    [credentials3951 (:credentials m3950) args3952 (:args m3950)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3953
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3951)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3953
       allocateConnectionOnInterconnect
       (directconnect/allocate-connection-on-interconnect-request
        (clojure.core/nth args3952 0)))))))
  (clojure.core/defn
   allocate-connection-on-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         bandwidth
                         general-progress-listener
                         connection-name
                         vlan
                         owner-account]}]]),
    :doc "Generate map for allocateConnectionOnInterconnect"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :allocate-connection-on-interconnect,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   allocate-connection-on-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id
                         bandwidth
                         general-progress-listener
                         connection-name
                         vlan
                         owner-account]}]]),
    :doc "Call allocateConnectionOnInterconnect"}
   [credentials3955 & args3956]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3957
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3955)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3957
      allocateConnectionOnInterconnect
      (directconnect/allocate-connection-on-interconnect-request
       (clojure.core/nth args3956 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-public-virtual-interface
   [m3958]
   (clojure.core/let
    [credentials3959 (:credentials m3958) args3960 (:args m3958)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3961
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3959)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3961
       createPublicVirtualInterface
       (directconnect/create-public-virtual-interface-request
        (clojure.core/nth args3960 0)))))))
  (clojure.core/defn
   create-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [new-public-virtual-interface
                         general-progress-listener
                         connection-id]}]]),
    :doc "Generate map for createPublicVirtualInterface"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-public-virtual-interface,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [new-public-virtual-interface
                         general-progress-listener
                         connection-id]}]]),
    :doc "Call createPublicVirtualInterface"}
   [credentials3963 & args3964]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3965
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3963)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3965
      createPublicVirtualInterface
      (directconnect/create-public-virtual-interface-request
       (clojure.core/nth args3964 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-connection
   [m3966]
   (clojure.core/let
    [credentials3967 (:credentials m3966) args3968 (:args m3966)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3969
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3967)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3969
       confirmConnection
       (directconnect/confirm-connection-request
        (clojure.core/nth args3968 0)))))))
  (clojure.core/defn
   confirm-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Generate map for confirmConnection"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :confirm-connection,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   confirm-connection
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener connection-id]}]]),
    :doc "Call confirmConnection"}
   [credentials3971 & args3972]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3973
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3971)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3973
      confirmConnection
      (directconnect/confirm-connection-request
       (clojure.core/nth args3972 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-private-virtual-interface
   [m3974]
   (clojure.core/let
    [credentials3975 (:credentials m3974) args3976 (:args m3974)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3977
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3975)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3977
       confirmPrivateVirtualInterface
       (directconnect/confirm-private-virtual-interface-request
        (clojure.core/nth args3976 0)))))))
  (clojure.core/defn
   confirm-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         virtual-gateway-id
                         general-progress-listener]}]]),
    :doc "Generate map for confirmPrivateVirtualInterface"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :confirm-private-virtual-interface,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   confirm-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         virtual-gateway-id
                         general-progress-listener]}]]),
    :doc "Call confirmPrivateVirtualInterface"}
   [credentials3979 & args3980]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3981
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3979)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3981
      confirmPrivateVirtualInterface
      (directconnect/confirm-private-virtual-interface-request
       (clojure.core/nth args3980 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-interconnect
   [m3982]
   (clojure.core/let
    [credentials3983 (:credentials m3982) args3984 (:args m3982)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3985
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3983)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3985
       createInterconnect
       (directconnect/create-interconnect-request
        (clojure.core/nth args3984 0)))))))
  (clojure.core/defn
   create-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [location
                         interconnect-name
                         general-progress-listener
                         bandwidth]}]]),
    :doc "Generate map for createInterconnect"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-interconnect,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [location
                         interconnect-name
                         general-progress-listener
                         bandwidth]}]]),
    :doc "Call createInterconnect"}
   [credentials3987 & args3988]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3989
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3987)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3989
      createInterconnect
      (directconnect/create-interconnect-request
       (clojure.core/nth args3988 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :confirm-public-virtual-interface
   [m3990]
   (clojure.core/let
    [credentials3991 (:credentials m3990) args3992 (:args m3990)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client3993
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3991)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3993
       confirmPublicVirtualInterface
       (directconnect/confirm-public-virtual-interface-request
        (clojure.core/nth args3992 0)))))))
  (clojure.core/defn
   confirm-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         general-progress-listener]}]]),
    :doc "Generate map for confirmPublicVirtualInterface"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :confirm-public-virtual-interface,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   confirm-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         general-progress-listener]}]]),
    :doc "Call confirmPublicVirtualInterface"}
   [credentials3995 & args3996]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client3997
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials3995)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client3997
      confirmPublicVirtualInterface
      (directconnect/confirm-public-virtual-interface-request
       (clojure.core/nth args3996 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-virtual-interface
   [m3998]
   (clojure.core/let
    [credentials3999 (:credentials m3998) args4000 (:args m3998)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4001
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials3999)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4001
       deleteVirtualInterface
       (directconnect/delete-virtual-interface-request
        (clojure.core/nth args4000 0)))))))
  (clojure.core/defn
   delete-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         general-progress-listener]}]]),
    :doc "Generate map for deleteVirtualInterface"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :delete-virtual-interface,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [virtual-interface-id
                         general-progress-listener]}]]),
    :doc "Call deleteVirtualInterface"}
   [credentials4003 & args4004]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4005
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4003)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4005
      deleteVirtualInterface
      (directconnect/delete-virtual-interface-request
       (clojure.core/nth args4004 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-private-virtual-interface
   [m4006]
   (clojure.core/let
    [credentials4007 (:credentials m4006) args4008 (:args m4006)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4009
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4007)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4009
       createPrivateVirtualInterface
       (directconnect/create-private-virtual-interface-request
        (clojure.core/nth args4008 0)))))))
  (clojure.core/defn
   create-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [new-private-virtual-interface
                         general-progress-listener
                         connection-id]}]]),
    :doc "Generate map for createPrivateVirtualInterface"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-private-virtual-interface,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [new-private-virtual-interface
                         general-progress-listener
                         connection-id]}]]),
    :doc "Call createPrivateVirtualInterface"}
   [credentials4011 & args4012]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4013
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4011)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4013
      createPrivateVirtualInterface
      (directconnect/create-private-virtual-interface-request
       (clojure.core/nth args4012 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-private-virtual-interface
   [m4014]
   (clojure.core/let
    [credentials4015 (:credentials m4014) args4016 (:args m4014)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4017
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4015)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4017
       allocatePrivateVirtualInterface
       (directconnect/allocate-private-virtual-interface-request
        (clojure.core/nth args4016 0)))))))
  (clojure.core/defn
   allocate-private-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [owner-account
                         new-private-virtual-interface-allocation
                         general-progress-listener
                         connection-id]}]]),
    :doc "Generate map for allocatePrivateVirtualInterface"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :allocate-private-virtual-interface,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   allocate-private-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [owner-account
                         new-private-virtual-interface-allocation
                         general-progress-listener
                         connection-id]}]]),
    :doc "Call allocatePrivateVirtualInterface"}
   [credentials4019 & args4020]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4021
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4019)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4021
      allocatePrivateVirtualInterface
      (directconnect/allocate-private-virtual-interface-request
       (clojure.core/nth args4020 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-interfaces
   [m4022]
   (clojure.core/let
    [credentials4023 (:credentials m4022) args4024 (:args m4022)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4025
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4023)]
     (clojure.core/case
      (clojure.core/count args4024)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4025
        describeVirtualInterfaces))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4025
        describeVirtualInterfaces
        (directconnect/describe-virtual-interfaces-request
         (clojure.core/nth args4024 0))))))))
  (clojure.core/defn
   describe-virtual-interfaces-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [virtual-interface-id
                         general-progress-listener
                         connection-id]}]]),
    :doc "Generate map for describeVirtualInterfaces, describeVirtualInterfaces"}
   ([credentials__1649__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-virtual-interfaces,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-virtual-interfaces,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-virtual-interfaces
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [virtual-interface-id
                         general-progress-listener
                         connection-id]}]]),
    :doc "Call describeVirtualInterfaces, describeVirtualInterfaces"}
   [credentials4027 & args4028]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4029
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4027)]
    (clojure.core/case
     (clojure.core/count args4028)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4029
       describeVirtualInterfaces))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4029
       describeVirtualInterfaces
       (directconnect/describe-virtual-interfaces-request
        (clojure.core/nth args4028 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-connections
   [m4030]
   (clojure.core/let
    [credentials4031 (:credentials m4030) args4032 (:args m4030)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4033
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4031)]
     (clojure.core/case
      (clojure.core/count args4032)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4033
        describeConnections
        (directconnect/describe-connections-request
         (clojure.core/nth args4032 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4033
        describeConnections))))))
  (clojure.core/defn
   describe-connections-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener connection-id]}]
                [credentials]]),
    :doc "Generate map for describeConnections, describeConnections"}
   ([credentials__1649__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-connections,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-connections,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-connections
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener connection-id]}]
                [credentials]]),
    :doc "Call describeConnections, describeConnections"}
   [credentials4035 & args4036]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4037
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4035)]
    (clojure.core/case
     (clojure.core/count args4036)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4037
       describeConnections
       (directconnect/describe-connections-request
        (clojure.core/nth args4036 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4037
       describeConnections))))))
 (do
  (clojure.core/defmethod
   directconnect
   :allocate-public-virtual-interface
   [m4038]
   (clojure.core/let
    [credentials4039 (:credentials m4038) args4040 (:args m4038)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4041
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4039)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4041
       allocatePublicVirtualInterface
       (directconnect/allocate-public-virtual-interface-request
        (clojure.core/nth args4040 0)))))))
  (clojure.core/defn
   allocate-public-virtual-interface-map
   {:arglists (quote
               [[credentials
                 {:keys [owner-account
                         new-public-virtual-interface-allocation
                         general-progress-listener
                         connection-id]}]]),
    :doc "Generate map for allocatePublicVirtualInterface"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :allocate-public-virtual-interface,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   allocate-public-virtual-interface
   {:arglists (quote
               [[credentials
                 {:keys [owner-account
                         new-public-virtual-interface-allocation
                         general-progress-listener
                         connection-id]}]]),
    :doc "Call allocatePublicVirtualInterface"}
   [credentials4043 & args4044]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4045
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4043)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4045
      allocatePublicVirtualInterface
      (directconnect/allocate-public-virtual-interface-request
       (clojure.core/nth args4044 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-interconnects
   [m4046]
   (clojure.core/let
    [credentials4047 (:credentials m4046) args4048 (:args m4046)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4049
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4047)]
     (clojure.core/case
      (clojure.core/count args4048)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4049
        describeInterconnects))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4049
        describeInterconnects
        (directconnect/describe-interconnects-request
         (clojure.core/nth args4048 0))))))))
  (clojure.core/defn
   describe-interconnects-map
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Generate map for describeInterconnects, describeInterconnects"}
   ([credentials__1649__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-interconnects,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-interconnects,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-interconnects
   {:arglists (quote
               [[credentials]
                [credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Call describeInterconnects, describeInterconnects"}
   [credentials4051 & args4052]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4053
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4051)]
    (clojure.core/case
     (clojure.core/count args4052)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4053
       describeInterconnects))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4053
       describeInterconnects
       (directconnect/describe-interconnects-request
        (clojure.core/nth args4052 0))))))))
 (do
  (clojure.core/defmethod
   directconnect
   :create-connection
   [m4054]
   (clojure.core/let
    [credentials4055 (:credentials m4054) args4056 (:args m4054)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4057
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4055)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4057
       createConnection
       (directconnect/create-connection-request
        (clojure.core/nth args4056 0)))))))
  (clojure.core/defn
   create-connection-map
   {:arglists (quote
               [[credentials
                 {:keys [location
                         general-progress-listener
                         connection-name
                         bandwidth]}]]),
    :doc "Generate map for createConnection"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :create-connection,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-connection
   {:arglists (quote
               [[credentials
                 {:keys [location
                         general-progress-listener
                         connection-name
                         bandwidth]}]]),
    :doc "Call createConnection"}
   [credentials4059 & args4060]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4061
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4059)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4061
      createConnection
      (directconnect/create-connection-request
       (clojure.core/nth args4060 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :delete-interconnect
   [m4062]
   (clojure.core/let
    [credentials4063 (:credentials m4062) args4064 (:args m4062)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4065
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4063)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4065
       deleteInterconnect
       (directconnect/delete-interconnect-request
        (clojure.core/nth args4064 0)))))))
  (clojure.core/defn
   delete-interconnect-map
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Generate map for deleteInterconnect"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :delete-interconnect,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-interconnect
   {:arglists (quote
               [[credentials
                 {:keys [interconnect-id general-progress-listener]}]]),
    :doc "Call deleteInterconnect"}
   [credentials4067 & args4068]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4069
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4067)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4069
      deleteInterconnect
      (directconnect/delete-interconnect-request
       (clojure.core/nth args4068 0)))))))
 (do
  (clojure.core/defmethod
   directconnect
   :describe-virtual-gateways
   [m4070]
   (clojure.core/let
    [credentials4071 (:credentials m4070) args4072 (:args m4070)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
      client4073
      (com.palletops.awaze.common/aws-client
       :directconnect
       credentials4071)]
     (clojure.core/case
      (clojure.core/count args4072)
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4073
        describeVirtualGateways))
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4073
        describeVirtualGateways
        (directconnect/describe-virtual-gateways-request
         (clojure.core/nth args4072 0))))))))
  (clojure.core/defn
   describe-virtual-gateways-map
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Generate map for describeVirtualGateways, describeVirtualGateways"}
   ([credentials__1649__auto__]
    {:args [],
     :client :directconnect,
     :fn :describe-virtual-gateways,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :directconnect,
     :fn :describe-virtual-gateways,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-virtual-gateways
   {:arglists (quote
               [[credentials]
                [credentials {:keys [general-progress-listener]}]]),
    :doc "Call describeVirtualGateways, describeVirtualGateways"}
   [credentials4075 & args4076]
   (clojure.core/let
    [^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
     client4077
     (com.palletops.awaze.common/aws-client
      :directconnect
      credentials4075)]
    (clojure.core/case
     (clojure.core/count args4076)
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4077
       describeVirtualGateways))
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.directconnect.AmazonDirectConnectClient}
client4077
       describeVirtualGateways
       (directconnect/describe-virtual-gateways-request
        (clojure.core/nth args4076 0)))))))))
