(ns
 com.palletops.awaze.cloudsearch
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.cloudsearch :as cloudsearch]))


(do
 (clojure.core/defmethod
  com.palletops.awaze.common/aws-client-factory
  :cloudsearch
  [___1598__auto__
^{:tag com.amazonaws.auth.BasicAWSCredentials}
credentials__1599__auto__]
  (new
   com.amazonaws.services.cloudsearch.AmazonCloudSearchClient
   credentials__1599__auto__))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceData}
source-data
  [m8930]
  (clojure.core/let
   [bean8929
    (new com.amazonaws.services.cloudsearch.model.SourceData)]
   (clojure.core/when-let
    [v8931 (:default-value m8930)]
    (. bean8929 setDefaultValue (clojure.core/str v8931)))
   (clojure.core/when-let
    [v8931 (:source-name m8930)]
    (. bean8929 setSourceName (clojure.core/str v8931)))
   bean8929))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle}
source-data-trim-title
  [m8933]
  (clojure.core/let
   [bean8932
    (new com.amazonaws.services.cloudsearch.model.SourceDataTrimTitle)]
   (clojure.core/when-let
    [v8934 (:default-value m8933)]
    (. bean8932 setDefaultValue (clojure.core/str v8934)))
   (clojure.core/when-let
    [v8934 (:source-name m8933)]
    (. bean8932 setSourceName (clojure.core/str v8934)))
   (clojure.core/when-let
    [v8934 (:separator m8933)]
    (. bean8932 setSeparator (clojure.core/str v8934)))
   (clojure.core/when-let
    [v8934 (:language m8933)]
    (. bean8932 setLanguage (clojure.core/str v8934)))
   bean8932))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceDataMap}
source-data-map
  [m8936]
  (clojure.core/let
   [bean8935
    (new com.amazonaws.services.cloudsearch.model.SourceDataMap)]
   (clojure.core/when-let
    [v8937 (:default-value m8936)]
    (. bean8935 setDefaultValue (clojure.core/str v8937)))
   (clojure.core/when-let
    [v8937 (:source-name m8936)]
    (. bean8935 setSourceName (clojure.core/str v8937)))
   (clojure.core/when-let
    [v8937 (:cases m8936)]
    (.
     bean8935
     setCases
^{:tag java.util.Map}
(clojure.core/zipmap
 (clojure.core/map
  (clojure.core/fn [arg9022] (clojure.core/str arg9022))
  (clojure.core/keys v8937))
 (clojure.core/map
  (clojure.core/fn [arg9022] (clojure.core/str arg9022))
  (clojure.core/vals v8937)))))
   bean8935))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UIntOptions}
uint-options
  [m8939]
  (clojure.core/let
   [bean8938
    (new com.amazonaws.services.cloudsearch.model.UIntOptions)]
   (clojure.core/when-let
    [v8940 (:default-value m8939)]
    (. bean8938 setDefaultValue (clojure.core/int v8940)))
   bean8938))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.LiteralOptions}
literal-options
  [m8942]
  (clojure.core/let
   [bean8941
    (new com.amazonaws.services.cloudsearch.model.LiteralOptions)]
   (clojure.core/when-let
    [v8943 (:default-value m8942)]
    (. bean8941 setDefaultValue (clojure.core/str v8943)))
   (clojure.core/when-let
    [v8943 (:search-enabled m8942)]
    (. bean8941 setSearchEnabled (clojure.core/boolean v8943)))
   (clojure.core/when-let
    [v8943 (:facet-enabled m8942)]
    (. bean8941 setFacetEnabled (clojure.core/boolean v8943)))
   (clojure.core/when-let
    [v8943 (:result-enabled m8942)]
    (. bean8941 setResultEnabled (clojure.core/boolean v8943)))
   bean8941))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.TextOptions}
text-options
  [m8945]
  (clojure.core/let
   [bean8944
    (new com.amazonaws.services.cloudsearch.model.TextOptions)]
   (clojure.core/when-let
    [v8946 (:default-value m8945)]
    (. bean8944 setDefaultValue (clojure.core/str v8946)))
   (clojure.core/when-let
    [v8946 (:facet-enabled m8945)]
    (. bean8944 setFacetEnabled (clojure.core/boolean v8946)))
   (clojure.core/when-let
    [v8946 (:result-enabled m8945)]
    (. bean8944 setResultEnabled (clojure.core/boolean v8946)))
   (clojure.core/when-let
    [v8946 (:text-processor m8945)]
    (. bean8944 setTextProcessor (clojure.core/str v8946)))
   bean8944))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.SourceAttribute}
source-attribute
  [m8948]
  (clojure.core/let
   [bean8947
    (new com.amazonaws.services.cloudsearch.model.SourceAttribute)]
   (clojure.core/when-let
    [v8949 (:source-data-function m8948)]
    (. bean8947 setSourceDataFunction (clojure.core/str v8949)))
   (clojure.core/when-let
    [v8949 (:source-data-copy m8948)]
    (. bean8947 setSourceDataCopy (cloudsearch/source-data v8949)))
   (clojure.core/when-let
    [v8949 (:source-data-trim-title m8948)]
    (.
     bean8947
     setSourceDataTrimTitle
     (cloudsearch/source-data-trim-title v8949)))
   (clojure.core/when-let
    [v8949 (:source-data-map m8948)]
    (. bean8947 setSourceDataMap (cloudsearch/source-data-map v8949)))
   bean8947))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexField}
index-field
  [m8951]
  (clojure.core/let
   [bean8950
    (new com.amazonaws.services.cloudsearch.model.IndexField)]
   (clojure.core/when-let
    [v8952 (:index-field-name m8951)]
    (. bean8950 setIndexFieldName (clojure.core/str v8952)))
   (clojure.core/when-let
    [v8952 (:index-field-type m8951)]
    (. bean8950 setIndexFieldType (clojure.core/str v8952)))
   (clojure.core/when-let
    [v8952 (:uint-options m8951)]
    (. bean8950 setUIntOptions (cloudsearch/uint-options v8952)))
   (clojure.core/when-let
    [v8952 (:literal-options m8951)]
    (. bean8950 setLiteralOptions (cloudsearch/literal-options v8952)))
   (clojure.core/when-let
    [v8952 (:text-options m8951)]
    (. bean8950 setTextOptions (cloudsearch/text-options v8952)))
   (clojure.core/when-let
    [v8952 (:source-attributes m8951)]
    (.
     bean8950
     setSourceAttributes
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9023] (cloudsearch/source-attribute arg9023))
 v8952)))
   bean8950))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.NamedRankExpression}
named-rank-expression
  [m8954]
  (clojure.core/let
   [bean8953
    (new com.amazonaws.services.cloudsearch.model.NamedRankExpression)]
   (clojure.core/when-let
    [v8955 (:rank-name m8954)]
    (. bean8953 setRankName (clojure.core/str v8955)))
   (clojure.core/when-let
    [v8955 (:rank-expression m8954)]
    (. bean8953 setRankExpression (clojure.core/str v8955)))
   bean8953))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest}
update-default-search-field-request
  [m8957]
  (clojure.core/let
   [bean8956
    (new
     com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest)]
   (clojure.core/when-let
    [v8958 (:domain-name m8957)]
    (. bean8956 setDomainName (clojure.core/str v8958)))
   (clojure.core/when-let
    [v8958 (:default-search-field m8957)]
    (. bean8956 setDefaultSearchField (clojure.core/str v8958)))
   bean8956))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest}
describe-service-access-policies-request
  [m8960]
  (clojure.core/let
   [bean8959
    (new
     com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest)]
   (clojure.core/when-let
    [v8961 (:domain-name m8960)]
    (. bean8959 setDomainName (clojure.core/str v8961)))
   bean8959))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest}
describe-domains-request
  [m8963]
  (clojure.core/let
   [bean8962
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest)]
   (clojure.core/when-let
    [v8964 (:domain-names m8963)]
    (.
     bean8962
     setDomainNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9024] (clojure.core/str arg9024))
 v8964)))
   bean8962))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest}
define-index-field-request
  [m8966]
  (clojure.core/let
   [bean8965
    (new
     com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest)]
   (clojure.core/when-let
    [v8967 (:domain-name m8966)]
    (. bean8965 setDomainName (clojure.core/str v8967)))
   (clojure.core/when-let
    [v8967 (:index-field m8966)]
    (. bean8965 setIndexField (cloudsearch/index-field v8967)))
   bean8965))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest}
define-rank-expression-request
  [m8969]
  (clojure.core/let
   [bean8968
    (new
     com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest)]
   (clojure.core/when-let
    [v8970 (:domain-name m8969)]
    (. bean8968 setDomainName (clojure.core/str v8970)))
   (clojure.core/when-let
    [v8970 (:rank-expression m8969)]
    (.
     bean8968
     setRankExpression
     (cloudsearch/named-rank-expression v8970)))
   bean8968))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest}
update-stopword-options-request
  [m8972]
  (clojure.core/let
   [bean8971
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest)]
   (clojure.core/when-let
    [v8973 (:domain-name m8972)]
    (. bean8971 setDomainName (clojure.core/str v8973)))
   (clojure.core/when-let
    [v8973 (:stopwords m8972)]
    (. bean8971 setStopwords (clojure.core/str v8973)))
   bean8971))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest}
delete-rank-expression-request
  [m8975]
  (clojure.core/let
   [bean8974
    (new
     com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest)]
   (clojure.core/when-let
    [v8976 (:domain-name m8975)]
    (. bean8974 setDomainName (clojure.core/str v8976)))
   (clojure.core/when-let
    [v8976 (:rank-name m8975)]
    (. bean8974 setRankName (clojure.core/str v8976)))
   bean8974))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest}
describe-default-search-field-request
  [m8978]
  (clojure.core/let
   [bean8977
    (new
     com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest)]
   (clojure.core/when-let
    [v8979 (:domain-name m8978)]
    (. bean8977 setDomainName (clojure.core/str v8979)))
   bean8977))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.CreateDomainRequest}
create-domain-request
  [m8981]
  (clojure.core/let
   [bean8980
    (new com.amazonaws.services.cloudsearch.model.CreateDomainRequest)]
   (clojure.core/when-let
    [v8982 (:domain-name m8981)]
    (. bean8980 setDomainName (clojure.core/str v8982)))
   bean8980))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest}
describe-stemming-options-request
  [m8984]
  (clojure.core/let
   [bean8983
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest)]
   (clojure.core/when-let
    [v8985 (:domain-name m8984)]
    (. bean8983 setDomainName (clojure.core/str v8985)))
   bean8983))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateAvailabilityOptionsRequest}
update-availability-options-request
  [m8987]
  (clojure.core/let
   [bean8986
    (new
     com.amazonaws.services.cloudsearch.model.UpdateAvailabilityOptionsRequest)]
   (clojure.core/when-let
    [v8988 (:domain-name m8987)]
    (. bean8986 setDomainName (clojure.core/str v8988)))
   (clojure.core/when-let
    [v8988 (:multi-az m8987)]
    (. bean8986 setMultiAZ (clojure.core/boolean v8988)))
   bean8986))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest}
describe-index-fields-request
  [m8990]
  (clojure.core/let
   [bean8989
    (new
     com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest)]
   (clojure.core/when-let
    [v8991 (:domain-name m8990)]
    (. bean8989 setDomainName (clojure.core/str v8991)))
   (clojure.core/when-let
    [v8991 (:field-names m8990)]
    (.
     bean8989
     setFieldNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9025] (clojure.core/str arg9025))
 v8991)))
   bean8989))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeAvailabilityOptionsRequest}
describe-availability-options-request
  [m8993]
  (clojure.core/let
   [bean8992
    (new
     com.amazonaws.services.cloudsearch.model.DescribeAvailabilityOptionsRequest)]
   (clojure.core/when-let
    [v8994 (:domain-name m8993)]
    (. bean8992 setDomainName (clojure.core/str v8994)))
   bean8992))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest}
delete-index-field-request
  [m8996]
  (clojure.core/let
   [bean8995
    (new
     com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest)]
   (clojure.core/when-let
    [v8997 (:domain-name m8996)]
    (. bean8995 setDomainName (clojure.core/str v8997)))
   (clojure.core/when-let
    [v8997 (:index-field-name m8996)]
    (. bean8995 setIndexFieldName (clojure.core/str v8997)))
   bean8995))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest}
describe-stopword-options-request
  [m8999]
  (clojure.core/let
   [bean8998
    (new
     com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest)]
   (clojure.core/when-let
    [v9000 (:domain-name m8999)]
    (. bean8998 setDomainName (clojure.core/str v9000)))
   bean8998))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest}
describe-synonym-options-request
  [m9002]
  (clojure.core/let
   [bean9001
    (new
     com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest)]
   (clojure.core/when-let
    [v9003 (:domain-name m9002)]
    (. bean9001 setDomainName (clojure.core/str v9003)))
   bean9001))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest}
update-synonym-options-request
  [m9005]
  (clojure.core/let
   [bean9004
    (new
     com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest)]
   (clojure.core/when-let
    [v9006 (:domain-name m9005)]
    (. bean9004 setDomainName (clojure.core/str v9006)))
   (clojure.core/when-let
    [v9006 (:synonyms m9005)]
    (. bean9004 setSynonyms (clojure.core/str v9006)))
   bean9004))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DeleteDomainRequest}
delete-domain-request
  [m9008]
  (clojure.core/let
   [bean9007
    (new com.amazonaws.services.cloudsearch.model.DeleteDomainRequest)]
   (clojure.core/when-let
    [v9009 (:domain-name m9008)]
    (. bean9007 setDomainName (clojure.core/str v9009)))
   bean9007))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest}
describe-rank-expressions-request
  [m9011]
  (clojure.core/let
   [bean9010
    (new
     com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest)]
   (clojure.core/when-let
    [v9012 (:domain-name m9011)]
    (. bean9010 setDomainName (clojure.core/str v9012)))
   (clojure.core/when-let
    [v9012 (:rank-names m9011)]
    (.
     bean9010
     setRankNames
^{:tag java.util.Collection}
(clojure.core/map
 (clojure.core/fn [arg9026] (clojure.core/str arg9026))
 v9012)))
   bean9010))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest}
index-documents-request
  [m9014]
  (clojure.core/let
   [bean9013
    (new
     com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest)]
   (clojure.core/when-let
    [v9015 (:domain-name m9014)]
    (. bean9013 setDomainName (clojure.core/str v9015)))
   bean9013))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest}
update-service-access-policies-request
  [m9017]
  (clojure.core/let
   [bean9016
    (new
     com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest)]
   (clojure.core/when-let
    [v9018 (:domain-name m9017)]
    (. bean9016 setDomainName (clojure.core/str v9018)))
   (clojure.core/when-let
    [v9018 (:access-policies m9017)]
    (. bean9016 setAccessPolicies (clojure.core/str v9018)))
   bean9016))
 (clojure.core/defn
^{:tag com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest}
update-stemming-options-request
  [m9020]
  (clojure.core/let
   [bean9019
    (new
     com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest)]
   (clojure.core/when-let
    [v9021 (:domain-name m9020)]
    (. bean9019 setDomainName (clojure.core/str v9021)))
   (clojure.core/when-let
    [v9021 (:stems m9020)]
    (. bean9019 setStems (clojure.core/str v9021)))
   bean9019))
 (clojure.core/defmulti
  cloudsearch
  (clojure.core/fn
   cloudsearch
   [m__1681__auto__]
   (:fn m__1681__auto__)))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-default-search-field
   [m9027]
   (clojure.core/let
    [credentials9028 (:credentials m9027) args9029 (:args m9027)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9030
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9028)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9030
       updateDefaultSearchField
       (cloudsearch/update-default-search-field-request
        (clojure.core/nth args9029 0)))))))
  (clojure.core/defn
   update-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         domain-name
                         default-search-field]}]]),
    :doc "Generate map for updateDefaultSearchField"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-default-search-field,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         domain-name
                         default-search-field]}]]),
    :doc "Call updateDefaultSearchField"}
   [credentials9032 & args9033]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9034
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9032)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9034
      updateDefaultSearchField
      (cloudsearch/update-default-search-field-request
       (clojure.core/nth args9033 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-service-access-policies
   [m9035]
   (clojure.core/let
    [credentials9036 (:credentials m9035) args9037 (:args m9035)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9038
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9036)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9038
       describeServiceAccessPolicies
       (cloudsearch/describe-service-access-policies-request
        (clojure.core/nth args9037 0)))))))
  (clojure.core/defn
   describe-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeServiceAccessPolicies"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-service-access-policies,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeServiceAccessPolicies"}
   [credentials9040 & args9041]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9042
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9040)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9042
      describeServiceAccessPolicies
      (cloudsearch/describe-service-access-policies-request
       (clojure.core/nth args9041 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-domains
   [m9043]
   (clojure.core/let
    [credentials9044 (:credentials m9043) args9045 (:args m9043)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9046
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9044)]
     (clojure.core/case
      (clojure.core/count args9045)
      1
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9046
        describeDomains
        (cloudsearch/describe-domains-request
         (clojure.core/nth args9045 0))))
      0
      (com.palletops.awaze.common/to-data
       (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9046
        describeDomains))))))
  (clojure.core/defn
   describe-domains-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-names]}]
                [credentials]]),
    :doc "Generate map for describeDomains, describeDomains"}
   ([credentials__1649__auto__]
    {:args [],
     :client :cloudsearch,
     :fn :describe-domains,
     :credentials credentials__1649__auto__})
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-domains,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-domains
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-names]}]
                [credentials]]),
    :doc "Call describeDomains, describeDomains"}
   [credentials9048 & args9049]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9050
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9048)]
    (clojure.core/case
     (clojure.core/count args9049)
     1
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9050
       describeDomains
       (cloudsearch/describe-domains-request
        (clojure.core/nth args9049 0))))
     0
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9050
       describeDomains))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-index-field
   [m9051]
   (clojure.core/let
    [credentials9052 (:credentials m9051) args9053 (:args m9051)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9054
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9052)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9054
       defineIndexField
       (cloudsearch/define-index-field-request
        (clojure.core/nth args9053 0)))))))
  (clojure.core/defn
   define-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [index-field
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for defineIndexField"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :define-index-field,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   define-index-field
   {:arglists (quote
               [[credentials
                 {:keys [index-field
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call defineIndexField"}
   [credentials9056 & args9057]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9058
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9056)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9058
      defineIndexField
      (cloudsearch/define-index-field-request
       (clojure.core/nth args9057 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :define-rank-expression
   [m9059]
   (clojure.core/let
    [credentials9060 (:credentials m9059) args9061 (:args m9059)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9062
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9060)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9062
       defineRankExpression
       (cloudsearch/define-rank-expression-request
        (clojure.core/nth args9061 0)))))))
  (clojure.core/defn
   define-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [rank-expression
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for defineRankExpression"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :define-rank-expression,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   define-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [rank-expression
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call defineRankExpression"}
   [credentials9064 & args9065]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9066
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9064)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9066
      defineRankExpression
      (cloudsearch/define-rank-expression-request
       (clojure.core/nth args9065 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stopword-options
   [m9067]
   (clojure.core/let
    [credentials9068 (:credentials m9067) args9069 (:args m9067)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9070
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9068)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9070
       updateStopwordOptions
       (cloudsearch/update-stopword-options-request
        (clojure.core/nth args9069 0)))))))
  (clojure.core/defn
   update-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [stopwords
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for updateStopwordOptions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-stopword-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [stopwords
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call updateStopwordOptions"}
   [credentials9072 & args9073]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9074
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9072)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9074
      updateStopwordOptions
      (cloudsearch/update-stopword-options-request
       (clojure.core/nth args9073 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-rank-expression
   [m9075]
   (clojure.core/let
    [credentials9076 (:credentials m9075) args9077 (:args m9075)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9078
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9076)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9078
       deleteRankExpression
       (cloudsearch/delete-rank-expression-request
        (clojure.core/nth args9077 0)))))))
  (clojure.core/defn
   delete-rank-expression-map
   {:arglists (quote
               [[credentials
                 {:keys [rank-name
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for deleteRankExpression"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :delete-rank-expression,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-rank-expression
   {:arglists (quote
               [[credentials
                 {:keys [rank-name
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call deleteRankExpression"}
   [credentials9080 & args9081]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9082
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9080)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9082
      deleteRankExpression
      (cloudsearch/delete-rank-expression-request
       (clojure.core/nth args9081 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-default-search-field
   [m9083]
   (clojure.core/let
    [credentials9084 (:credentials m9083) args9085 (:args m9083)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9086
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9084)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9086
       describeDefaultSearchField
       (cloudsearch/describe-default-search-field-request
        (clojure.core/nth args9085 0)))))))
  (clojure.core/defn
   describe-default-search-field-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeDefaultSearchField"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-default-search-field,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-default-search-field
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeDefaultSearchField"}
   [credentials9088 & args9089]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9090
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9088)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9090
      describeDefaultSearchField
      (cloudsearch/describe-default-search-field-request
       (clojure.core/nth args9089 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :create-domain
   [m9091]
   (clojure.core/let
    [credentials9092 (:credentials m9091) args9093 (:args m9091)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9094
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9092)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9094
       createDomain
       (cloudsearch/create-domain-request
        (clojure.core/nth args9093 0)))))))
  (clojure.core/defn
   create-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for createDomain"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :create-domain,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   create-domain
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call createDomain"}
   [credentials9096 & args9097]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9098
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9096)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9098
      createDomain
      (cloudsearch/create-domain-request
       (clojure.core/nth args9097 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stemming-options
   [m9099]
   (clojure.core/let
    [credentials9100 (:credentials m9099) args9101 (:args m9099)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9102
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9100)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9102
       describeStemmingOptions
       (cloudsearch/describe-stemming-options-request
        (clojure.core/nth args9101 0)))))))
  (clojure.core/defn
   describe-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeStemmingOptions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-stemming-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeStemmingOptions"}
   [credentials9104 & args9105]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9106
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9104)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9106
      describeStemmingOptions
      (cloudsearch/describe-stemming-options-request
       (clojure.core/nth args9105 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-availability-options
   [m9107]
   (clojure.core/let
    [credentials9108 (:credentials m9107) args9109 (:args m9107)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9110
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9108)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9110
       updateAvailabilityOptions
       (cloudsearch/update-availability-options-request
        (clojure.core/nth args9109 0)))))))
  (clojure.core/defn
   update-availability-options-map
   {:arglists (quote
               [[credentials
                 {:keys [multi-az
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for updateAvailabilityOptions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-availability-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-availability-options
   {:arglists (quote
               [[credentials
                 {:keys [multi-az
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call updateAvailabilityOptions"}
   [credentials9112 & args9113]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9114
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9112)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9114
      updateAvailabilityOptions
      (cloudsearch/update-availability-options-request
       (clojure.core/nth args9113 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-index-fields
   [m9115]
   (clojure.core/let
    [credentials9116 (:credentials m9115) args9117 (:args m9115)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9118
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9116)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9118
       describeIndexFields
       (cloudsearch/describe-index-fields-request
        (clojure.core/nth args9117 0)))))))
  (clojure.core/defn
   describe-index-fields-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         field-names
                         domain-name]}]]),
    :doc "Generate map for describeIndexFields"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-index-fields,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-index-fields
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         field-names
                         domain-name]}]]),
    :doc "Call describeIndexFields"}
   [credentials9120 & args9121]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9122
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9120)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9122
      describeIndexFields
      (cloudsearch/describe-index-fields-request
       (clojure.core/nth args9121 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-availability-options
   [m9123]
   (clojure.core/let
    [credentials9124 (:credentials m9123) args9125 (:args m9123)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9126
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9124)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9126
       describeAvailabilityOptions
       (cloudsearch/describe-availability-options-request
        (clojure.core/nth args9125 0)))))))
  (clojure.core/defn
   describe-availability-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeAvailabilityOptions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-availability-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-availability-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeAvailabilityOptions"}
   [credentials9128 & args9129]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9130
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9128)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9130
      describeAvailabilityOptions
      (cloudsearch/describe-availability-options-request
       (clojure.core/nth args9129 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-index-field
   [m9131]
   (clojure.core/let
    [credentials9132 (:credentials m9131) args9133 (:args m9131)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9134
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9132)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9134
       deleteIndexField
       (cloudsearch/delete-index-field-request
        (clojure.core/nth args9133 0)))))))
  (clojure.core/defn
   delete-index-field-map
   {:arglists (quote
               [[credentials
                 {:keys [index-field-name
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for deleteIndexField"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :delete-index-field,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-index-field
   {:arglists (quote
               [[credentials
                 {:keys [index-field-name
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call deleteIndexField"}
   [credentials9136 & args9137]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9138
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9136)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9138
      deleteIndexField
      (cloudsearch/delete-index-field-request
       (clojure.core/nth args9137 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-stopword-options
   [m9139]
   (clojure.core/let
    [credentials9140 (:credentials m9139) args9141 (:args m9139)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9142
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9140)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9142
       describeStopwordOptions
       (cloudsearch/describe-stopword-options-request
        (clojure.core/nth args9141 0)))))))
  (clojure.core/defn
   describe-stopword-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeStopwordOptions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-stopword-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-stopword-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeStopwordOptions"}
   [credentials9144 & args9145]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9146
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9144)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9146
      describeStopwordOptions
      (cloudsearch/describe-stopword-options-request
       (clojure.core/nth args9145 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-synonym-options
   [m9147]
   (clojure.core/let
    [credentials9148 (:credentials m9147) args9149 (:args m9147)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9150
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9148)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9150
       describeSynonymOptions
       (cloudsearch/describe-synonym-options-request
        (clojure.core/nth args9149 0)))))))
  (clojure.core/defn
   describe-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for describeSynonymOptions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-synonym-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call describeSynonymOptions"}
   [credentials9152 & args9153]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9154
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9152)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9154
      describeSynonymOptions
      (cloudsearch/describe-synonym-options-request
       (clojure.core/nth args9153 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-synonym-options
   [m9155]
   (clojure.core/let
    [credentials9156 (:credentials m9155) args9157 (:args m9155)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9158
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9156)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9158
       updateSynonymOptions
       (cloudsearch/update-synonym-options-request
        (clojure.core/nth args9157 0)))))))
  (clojure.core/defn
   update-synonym-options-map
   {:arglists (quote
               [[credentials
                 {:keys [synonyms
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for updateSynonymOptions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-synonym-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-synonym-options
   {:arglists (quote
               [[credentials
                 {:keys [synonyms
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call updateSynonymOptions"}
   [credentials9160 & args9161]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9162
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9160)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9162
      updateSynonymOptions
      (cloudsearch/update-synonym-options-request
       (clojure.core/nth args9161 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :delete-domain
   [m9163]
   (clojure.core/let
    [credentials9164 (:credentials m9163) args9165 (:args m9163)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9166
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9164)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9166
       deleteDomain
       (cloudsearch/delete-domain-request
        (clojure.core/nth args9165 0)))))))
  (clojure.core/defn
   delete-domain-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for deleteDomain"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :delete-domain,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   delete-domain
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call deleteDomain"}
   [credentials9168 & args9169]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9170
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9168)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9170
      deleteDomain
      (cloudsearch/delete-domain-request
       (clojure.core/nth args9169 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :describe-rank-expressions
   [m9171]
   (clojure.core/let
    [credentials9172 (:credentials m9171) args9173 (:args m9171)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9174
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9172)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9174
       describeRankExpressions
       (cloudsearch/describe-rank-expressions-request
        (clojure.core/nth args9173 0)))))))
  (clojure.core/defn
   describe-rank-expressions-map
   {:arglists (quote
               [[credentials
                 {:keys [rank-names
                         general-progress-listener
                         domain-name]}]]),
    :doc "Generate map for describeRankExpressions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :describe-rank-expressions,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   describe-rank-expressions
   {:arglists (quote
               [[credentials
                 {:keys [rank-names
                         general-progress-listener
                         domain-name]}]]),
    :doc "Call describeRankExpressions"}
   [credentials9176 & args9177]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9178
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9176)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9178
      describeRankExpressions
      (cloudsearch/describe-rank-expressions-request
       (clojure.core/nth args9177 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :index-documents
   [m9179]
   (clojure.core/let
    [credentials9180 (:credentials m9179) args9181 (:args m9179)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9182
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9180)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9182
       indexDocuments
       (cloudsearch/index-documents-request
        (clojure.core/nth args9181 0)))))))
  (clojure.core/defn
   index-documents-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Generate map for indexDocuments"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :index-documents,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   index-documents
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener domain-name]}]]),
    :doc "Call indexDocuments"}
   [credentials9184 & args9185]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9186
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9184)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9186
      indexDocuments
      (cloudsearch/index-documents-request
       (clojure.core/nth args9185 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-service-access-policies
   [m9187]
   (clojure.core/let
    [credentials9188 (:credentials m9187) args9189 (:args m9187)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9190
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9188)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9190
       updateServiceAccessPolicies
       (cloudsearch/update-service-access-policies-request
        (clojure.core/nth args9189 0)))))))
  (clojure.core/defn
   update-service-access-policies-map
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         domain-name
                         access-policies]}]]),
    :doc "Generate map for updateServiceAccessPolicies"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-service-access-policies,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-service-access-policies
   {:arglists (quote
               [[credentials
                 {:keys [general-progress-listener
                         domain-name
                         access-policies]}]]),
    :doc "Call updateServiceAccessPolicies"}
   [credentials9192 & args9193]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9194
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9192)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9194
      updateServiceAccessPolicies
      (cloudsearch/update-service-access-policies-request
       (clojure.core/nth args9193 0)))))))
 (do
  (clojure.core/defmethod
   cloudsearch
   :update-stemming-options
   [m9195]
   (clojure.core/let
    [credentials9196 (:credentials m9195) args9197 (:args m9195)]
    (clojure.core/let
     [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
      client9198
      (com.palletops.awaze.common/aws-client
       :cloudsearch
       credentials9196)]
     (com.palletops.awaze.common/to-data
      (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9198
       updateStemmingOptions
       (cloudsearch/update-stemming-options-request
        (clojure.core/nth args9197 0)))))))
  (clojure.core/defn
   update-stemming-options-map
   {:arglists (quote
               [[credentials
                 {:keys [stems general-progress-listener domain-name]}]]),
    :doc "Generate map for updateStemmingOptions"}
   ([credentials__1649__auto__ a]
    {:args [a],
     :client :cloudsearch,
     :fn :update-stemming-options,
     :credentials credentials__1649__auto__}))
  (clojure.core/defn
   update-stemming-options
   {:arglists (quote
               [[credentials
                 {:keys [stems general-progress-listener domain-name]}]]),
    :doc "Call updateStemmingOptions"}
   [credentials9200 & args9201]
   (clojure.core/let
    [^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
     client9202
     (com.palletops.awaze.common/aws-client
      :cloudsearch
      credentials9200)]
    (com.palletops.awaze.common/to-data
     (.
^{:tag com.amazonaws.services.cloudsearch.AmazonCloudSearchClient}
client9202
      updateStemmingOptions
      (cloudsearch/update-stemming-options-request
       (clojure.core/nth args9201 0))))))))
