(ns
 com.palletops.awaze.beans.identitymanagement
 (:require
  [com.palletops.awaze.common]
  [com.palletops.awaze.beans.identitymanagement
   :as
   identitymanagement]))


(do
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.StatusType}
status-type
  [m11466]
  (.
   com.amazonaws.services.identitymanagement.model.StatusType
   fromValue
   (clojure.core/name m11466)))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.AssignmentStatusType}
assignment-status-type
  [m11469]
  (.
   com.amazonaws.services.identitymanagement.model.AssignmentStatusType
   fromValue
   (clojure.core/name m11469)))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetRolePolicyRequest}
get-role-policy-request
  [m11472]
  (clojure.core/let
   [bean11471
    (new
     com.amazonaws.services.identitymanagement.model.GetRolePolicyRequest)]
   (clojure.core/when-let
    [v11473 (:policy-name m11472)]
    (. bean11471 setPolicyName (clojure.core/str v11473)))
   (clojure.core/when-let
    [v11473 (:role-name m11472)]
    (. bean11471 setRoleName (clojure.core/str v11473)))
   bean11471))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ChangePasswordRequest}
change-password-request
  [m11475]
  (clojure.core/let
   [bean11474
    (new
     com.amazonaws.services.identitymanagement.model.ChangePasswordRequest)]
   (clojure.core/when-let
    [v11476 (:old-password m11475)]
    (. bean11474 setOldPassword (clojure.core/str v11476)))
   (clojure.core/when-let
    [v11476 (:new-password m11475)]
    (. bean11474 setNewPassword (clojure.core/str v11476)))
   bean11474))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeactivateMFADeviceRequest}
deactivate-mfadevice-request
  [m11478]
  (clojure.core/let
   [bean11477
    (new
     com.amazonaws.services.identitymanagement.model.DeactivateMFADeviceRequest)]
   (clojure.core/when-let
    [v11479 (:serial-number m11478)]
    (. bean11477 setSerialNumber (clojure.core/str v11479)))
   (clojure.core/when-let
    [v11479 (:user-name m11478)]
    (. bean11477 setUserName (clojure.core/str v11479)))
   bean11477))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ResyncMFADeviceRequest}
resync-mfadevice-request
  [m11481]
  (clojure.core/let
   [bean11480
    (new
     com.amazonaws.services.identitymanagement.model.ResyncMFADeviceRequest)]
   (clojure.core/when-let
    [v11482 (:serial-number m11481)]
    (. bean11480 setSerialNumber (clojure.core/str v11482)))
   (clojure.core/when-let
    [v11482 (:user-name m11481)]
    (. bean11480 setUserName (clojure.core/str v11482)))
   (clojure.core/when-let
    [v11482 (:authentication-code1 m11481)]
    (. bean11480 setAuthenticationCode1 (clojure.core/str v11482)))
   (clojure.core/when-let
    [v11482 (:authentication-code2 m11481)]
    (. bean11480 setAuthenticationCode2 (clojure.core/str v11482)))
   bean11480))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateLoginProfileRequest}
update-login-profile-request
  [m11484]
  (clojure.core/let
   [bean11483
    (new
     com.amazonaws.services.identitymanagement.model.UpdateLoginProfileRequest)]
   (clojure.core/when-let
    [v11485 (:password m11484)]
    (. bean11483 setPassword (clojure.core/str v11485)))
   (clojure.core/when-let
    [v11485 (:user-name m11484)]
    (. bean11483 setUserName (clojure.core/str v11485)))
   bean11483))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.PutRolePolicyRequest}
put-role-policy-request
  [m11487]
  (clojure.core/let
   [bean11486
    (new
     com.amazonaws.services.identitymanagement.model.PutRolePolicyRequest)]
   (clojure.core/when-let
    [v11488 (:policy-name m11487)]
    (. bean11486 setPolicyName (clojure.core/str v11488)))
   (clojure.core/when-let
    [v11488 (:policy-document m11487)]
    (. bean11486 setPolicyDocument (clojure.core/str v11488)))
   (clojure.core/when-let
    [v11488 (:role-name m11487)]
    (. bean11486 setRoleName (clojure.core/str v11488)))
   bean11486))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteSigningCertificateRequest}
delete-signing-certificate-request
  [m11490]
  (clojure.core/let
   [bean11489
    (new
     com.amazonaws.services.identitymanagement.model.DeleteSigningCertificateRequest)]
   (clojure.core/when-let
    [v11491 (:user-name m11490)]
    (. bean11489 setUserName (clojure.core/str v11491)))
   (clojure.core/when-let
    [v11491 (:certificate-id m11490)]
    (. bean11489 setCertificateId (clojure.core/str v11491)))
   bean11489))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteSAMLProviderRequest}
delete-samlprovider-request
  [m11493]
  (clojure.core/let
   [bean11492
    (new
     com.amazonaws.services.identitymanagement.model.DeleteSAMLProviderRequest)]
   (clojure.core/when-let
    [v11494 (:samlprovider-arn m11493)]
    (. bean11492 setSAMLProviderArn (clojure.core/str v11494)))
   bean11492))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteUserRequest}
delete-user-request
  [m11496]
  (clojure.core/let
   [bean11495
    (new
     com.amazonaws.services.identitymanagement.model.DeleteUserRequest)]
   (clojure.core/when-let
    [v11497 (:user-name m11496)]
    (. bean11495 setUserName (clojure.core/str v11497)))
   bean11495))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.AddUserToGroupRequest}
add-user-to-group-request
  [m11499]
  (clojure.core/let
   [bean11498
    (new
     com.amazonaws.services.identitymanagement.model.AddUserToGroupRequest)]
   (clojure.core/when-let
    [v11500 (:group-name m11499)]
    (. bean11498 setGroupName (clojure.core/str v11500)))
   (clojure.core/when-let
    [v11500 (:user-name m11499)]
    (. bean11498 setUserName (clojure.core/str v11500)))
   bean11498))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListAccountAliasesRequest}
list-account-aliases-request
  [m11502]
  (clojure.core/let
   [bean11501
    (new
     com.amazonaws.services.identitymanagement.model.ListAccountAliasesRequest)]
   (clojure.core/when-let
    [v11503 (:max-items m11502)]
    (. bean11501 setMaxItems (clojure.core/int v11503)))
   (clojure.core/when-let
    [v11503 (:marker m11502)]
    (. bean11501 setMarker (clojure.core/str v11503)))
   bean11501))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupRequest}
remove-user-from-group-request
  [m11505]
  (clojure.core/let
   [bean11504
    (new
     com.amazonaws.services.identitymanagement.model.RemoveUserFromGroupRequest)]
   (clojure.core/when-let
    [v11506 (:group-name m11505)]
    (. bean11504 setGroupName (clojure.core/str v11506)))
   (clojure.core/when-let
    [v11506 (:user-name m11505)]
    (. bean11504 setUserName (clojure.core/str v11506)))
   bean11504))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateGroupRequest}
update-group-request
  [m11508]
  (clojure.core/let
   [bean11507
    (new
     com.amazonaws.services.identitymanagement.model.UpdateGroupRequest)]
   (clojure.core/when-let
    [v11509 (:group-name m11508)]
    (. bean11507 setGroupName (clojure.core/str v11509)))
   (clojure.core/when-let
    [v11509 (:new-path m11508)]
    (. bean11507 setNewPath (clojure.core/str v11509)))
   (clojure.core/when-let
    [v11509 (:new-group-name m11508)]
    (. bean11507 setNewGroupName (clojure.core/str v11509)))
   bean11507))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateServerCertificateRequest}
update-server-certificate-request
  [m11511]
  (clojure.core/let
   [bean11510
    (new
     com.amazonaws.services.identitymanagement.model.UpdateServerCertificateRequest)]
   (clojure.core/when-let
    [v11512 (:server-certificate-name m11511)]
    (. bean11510 setServerCertificateName (clojure.core/str v11512)))
   (clojure.core/when-let
    [v11512 (:new-path m11511)]
    (. bean11510 setNewPath (clojure.core/str v11512)))
   (clojure.core/when-let
    [v11512 (:new-server-certificate-name m11511)]
    (.
     bean11510
     setNewServerCertificateName
     (clojure.core/str v11512)))
   bean11510))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteRolePolicyRequest}
delete-role-policy-request
  [m11514]
  (clojure.core/let
   [bean11513
    (new
     com.amazonaws.services.identitymanagement.model.DeleteRolePolicyRequest)]
   (clojure.core/when-let
    [v11515 (:policy-name m11514)]
    (. bean11513 setPolicyName (clojure.core/str v11515)))
   (clojure.core/when-let
    [v11515 (:role-name m11514)]
    (. bean11513 setRoleName (clojure.core/str v11515)))
   bean11513))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateAccessKeyRequest}
update-access-key-request
  [m11517]
  (clojure.core/let
   [bean11516
    (new
     com.amazonaws.services.identitymanagement.model.UpdateAccessKeyRequest)]
   (clojure.core/when-let
    [v11518 (:status m11517)]
    (. bean11516 setStatus (identitymanagement/status-type v11518)))
   (clojure.core/when-let
    [v11518 (:user-name m11517)]
    (. bean11516 setUserName (clojure.core/str v11518)))
   (clojure.core/when-let
    [v11518 (:access-key-id m11517)]
    (. bean11516 setAccessKeyId (clojure.core/str v11518)))
   bean11516))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteGroupRequest}
delete-group-request
  [m11520]
  (clojure.core/let
   [bean11519
    (new
     com.amazonaws.services.identitymanagement.model.DeleteGroupRequest)]
   (clojure.core/when-let
    [v11521 (:group-name m11520)]
    (. bean11519 setGroupName (clojure.core/str v11521)))
   bean11519))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListGroupsForUserRequest}
list-groups-for-user-request
  [m11523]
  (clojure.core/let
   [bean11522
    (new
     com.amazonaws.services.identitymanagement.model.ListGroupsForUserRequest)]
   (clojure.core/when-let
    [v11524 (:max-items m11523)]
    (. bean11522 setMaxItems (clojure.core/int v11524)))
   (clojure.core/when-let
    [v11524 (:marker m11523)]
    (. bean11522 setMarker (clojure.core/str v11524)))
   (clojure.core/when-let
    [v11524 (:user-name m11523)]
    (. bean11522 setUserName (clojure.core/str v11524)))
   bean11522))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest}
put-user-policy-request
  [m11526]
  (clojure.core/let
   [bean11525
    (new
     com.amazonaws.services.identitymanagement.model.PutUserPolicyRequest)]
   (clojure.core/when-let
    [v11527 (:policy-name m11526)]
    (. bean11525 setPolicyName (clojure.core/str v11527)))
   (clojure.core/when-let
    [v11527 (:user-name m11526)]
    (. bean11525 setUserName (clojure.core/str v11527)))
   (clojure.core/when-let
    [v11527 (:policy-document m11526)]
    (. bean11525 setPolicyDocument (clojure.core/str v11527)))
   bean11525))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetRoleRequest}
get-role-request
  [m11529]
  (clojure.core/let
   [bean11528
    (new
     com.amazonaws.services.identitymanagement.model.GetRoleRequest)]
   (clojure.core/when-let
    [v11530 (:role-name m11529)]
    (. bean11528 setRoleName (clojure.core/str v11530)))
   bean11528))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetAccountPasswordPolicyRequest}
get-account-password-policy-request
  [m11532]
  (clojure.core/let
   [bean11531
    (new
     com.amazonaws.services.identitymanagement.model.GetAccountPasswordPolicyRequest)]
   bean11531))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest}
list-access-keys-request
  [m11535]
  (clojure.core/let
   [bean11534
    (new
     com.amazonaws.services.identitymanagement.model.ListAccessKeysRequest)]
   (clojure.core/when-let
    [v11536 (:max-items m11535)]
    (. bean11534 setMaxItems (clojure.core/int v11536)))
   (clojure.core/when-let
    [v11536 (:marker m11535)]
    (. bean11534 setMarker (clojure.core/str v11536)))
   (clojure.core/when-let
    [v11536 (:user-name m11535)]
    (. bean11534 setUserName (clojure.core/str v11536)))
   bean11534))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteAccountAliasRequest}
delete-account-alias-request
  [m11538]
  (clojure.core/let
   [bean11537
    (new
     com.amazonaws.services.identitymanagement.model.DeleteAccountAliasRequest)]
   (clojure.core/when-let
    [v11539 (:account-alias m11538)]
    (. bean11537 setAccountAlias (clojure.core/str v11539)))
   bean11537))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetLoginProfileRequest}
get-login-profile-request
  [m11541]
  (clojure.core/let
   [bean11540
    (new
     com.amazonaws.services.identitymanagement.model.GetLoginProfileRequest)]
   (clojure.core/when-let
    [v11542 (:user-name m11541)]
    (. bean11540 setUserName (clojure.core/str v11542)))
   bean11540))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateLoginProfileRequest}
create-login-profile-request
  [m11544]
  (clojure.core/let
   [bean11543
    (new
     com.amazonaws.services.identitymanagement.model.CreateLoginProfileRequest)]
   (clojure.core/when-let
    [v11545 (:password m11544)]
    (. bean11543 setPassword (clojure.core/str v11545)))
   (clojure.core/when-let
    [v11545 (:user-name m11544)]
    (. bean11543 setUserName (clojure.core/str v11545)))
   bean11543))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListGroupsRequest}
list-groups-request
  [m11547]
  (clojure.core/let
   [bean11546
    (new
     com.amazonaws.services.identitymanagement.model.ListGroupsRequest)]
   (clojure.core/when-let
    [v11548 (:max-items m11547)]
    (. bean11546 setMaxItems (clojure.core/int v11548)))
   (clojure.core/when-let
    [v11548 (:marker m11547)]
    (. bean11546 setMarker (clojure.core/str v11548)))
   (clojure.core/when-let
    [v11548 (:path-prefix m11547)]
    (. bean11546 setPathPrefix (clojure.core/str v11548)))
   bean11546))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetAccountSummaryRequest}
get-account-summary-request
  [m11550]
  (clojure.core/let
   [bean11549
    (new
     com.amazonaws.services.identitymanagement.model.GetAccountSummaryRequest)]
   bean11549))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteAccountPasswordPolicyRequest}
delete-account-password-policy-request
  [m11553]
  (clojure.core/let
   [bean11552
    (new
     com.amazonaws.services.identitymanagement.model.DeleteAccountPasswordPolicyRequest)]
   bean11552))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest}
get-instance-profile-request
  [m11556]
  (clojure.core/let
   [bean11555
    (new
     com.amazonaws.services.identitymanagement.model.GetInstanceProfileRequest)]
   (clojure.core/when-let
    [v11557 (:instance-profile-name m11556)]
    (. bean11555 setInstanceProfileName (clojure.core/str v11557)))
   bean11555))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetUserRequest}
get-user-request
  [m11559]
  (clojure.core/let
   [bean11558
    (new
     com.amazonaws.services.identitymanagement.model.GetUserRequest)]
   (clojure.core/when-let
    [v11560 (:user-name m11559)]
    (. bean11558 setUserName (clojure.core/str v11560)))
   bean11558))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateSAMLProviderRequest}
update-samlprovider-request
  [m11562]
  (clojure.core/let
   [bean11561
    (new
     com.amazonaws.services.identitymanagement.model.UpdateSAMLProviderRequest)]
   (clojure.core/when-let
    [v11563 (:samlprovider-arn m11562)]
    (. bean11561 setSAMLProviderArn (clojure.core/str v11563)))
   (clojure.core/when-let
    [v11563 (:samlmetadata-document m11562)]
    (. bean11561 setSAMLMetadataDocument (clojure.core/str v11563)))
   bean11561))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateSAMLProviderRequest}
create-samlprovider-request
  [m11565]
  (clojure.core/let
   [bean11564
    (new
     com.amazonaws.services.identitymanagement.model.CreateSAMLProviderRequest)]
   (clojure.core/when-let
    [v11566 (:name m11565)]
    (. bean11564 setName (clojure.core/str v11566)))
   (clojure.core/when-let
    [v11566 (:samlmetadata-document m11565)]
    (. bean11564 setSAMLMetadataDocument (clojure.core/str v11566)))
   bean11564))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListSAMLProvidersRequest}
list-samlproviders-request
  [m11568]
  (clojure.core/let
   [bean11567
    (new
     com.amazonaws.services.identitymanagement.model.ListSAMLProvidersRequest)]
   bean11567))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteVirtualMFADeviceRequest}
delete-virtual-mfadevice-request
  [m11571]
  (clojure.core/let
   [bean11570
    (new
     com.amazonaws.services.identitymanagement.model.DeleteVirtualMFADeviceRequest)]
   (clojure.core/when-let
    [v11572 (:serial-number m11571)]
    (. bean11570 setSerialNumber (clojure.core/str v11572)))
   bean11570))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest}
create-access-key-request
  [m11574]
  (clojure.core/let
   [bean11573
    (new
     com.amazonaws.services.identitymanagement.model.CreateAccessKeyRequest)]
   (clojure.core/when-let
    [v11575 (:user-name m11574)]
    (. bean11573 setUserName (clojure.core/str v11575)))
   bean11573))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListInstanceProfilesRequest}
list-instance-profiles-request
  [m11577]
  (clojure.core/let
   [bean11576
    (new
     com.amazonaws.services.identitymanagement.model.ListInstanceProfilesRequest)]
   (clojure.core/when-let
    [v11578 (:max-items m11577)]
    (. bean11576 setMaxItems (clojure.core/int v11578)))
   (clojure.core/when-let
    [v11578 (:marker m11577)]
    (. bean11576 setMarker (clojure.core/str v11578)))
   (clojure.core/when-let
    [v11578 (:path-prefix m11577)]
    (. bean11576 setPathPrefix (clojure.core/str v11578)))
   bean11576))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.PutGroupPolicyRequest}
put-group-policy-request
  [m11580]
  (clojure.core/let
   [bean11579
    (new
     com.amazonaws.services.identitymanagement.model.PutGroupPolicyRequest)]
   (clojure.core/when-let
    [v11581 (:policy-name m11580)]
    (. bean11579 setPolicyName (clojure.core/str v11581)))
   (clojure.core/when-let
    [v11581 (:group-name m11580)]
    (. bean11579 setGroupName (clojure.core/str v11581)))
   (clojure.core/when-let
    [v11581 (:policy-document m11580)]
    (. bean11579 setPolicyDocument (clojure.core/str v11581)))
   bean11579))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetServerCertificateRequest}
get-server-certificate-request
  [m11583]
  (clojure.core/let
   [bean11582
    (new
     com.amazonaws.services.identitymanagement.model.GetServerCertificateRequest)]
   (clojure.core/when-let
    [v11584 (:server-certificate-name m11583)]
    (. bean11582 setServerCertificateName (clojure.core/str v11584)))
   bean11582))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UploadServerCertificateRequest}
upload-server-certificate-request
  [m11586]
  (clojure.core/let
   [bean11585
    (new
     com.amazonaws.services.identitymanagement.model.UploadServerCertificateRequest)]
   (clojure.core/when-let
    [v11587 (:path m11586)]
    (. bean11585 setPath (clojure.core/str v11587)))
   (clojure.core/when-let
    [v11587 (:server-certificate-name m11586)]
    (. bean11585 setServerCertificateName (clojure.core/str v11587)))
   (clojure.core/when-let
    [v11587 (:certificate-body m11586)]
    (. bean11585 setCertificateBody (clojure.core/str v11587)))
   (clojure.core/when-let
    [v11587 (:private-key m11586)]
    (. bean11585 setPrivateKey (clojure.core/str v11587)))
   (clojure.core/when-let
    [v11587 (:certificate-chain m11586)]
    (. bean11585 setCertificateChain (clojure.core/str v11587)))
   bean11585))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListRolePoliciesRequest}
list-role-policies-request
  [m11589]
  (clojure.core/let
   [bean11588
    (new
     com.amazonaws.services.identitymanagement.model.ListRolePoliciesRequest)]
   (clojure.core/when-let
    [v11590 (:max-items m11589)]
    (. bean11588 setMaxItems (clojure.core/int v11590)))
   (clojure.core/when-let
    [v11590 (:marker m11589)]
    (. bean11588 setMarker (clojure.core/str v11590)))
   (clojure.core/when-let
    [v11590 (:role-name m11589)]
    (. bean11588 setRoleName (clojure.core/str v11590)))
   bean11588))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest}
add-role-to-instance-profile-request
  [m11592]
  (clojure.core/let
   [bean11591
    (new
     com.amazonaws.services.identitymanagement.model.AddRoleToInstanceProfileRequest)]
   (clojure.core/when-let
    [v11593 (:role-name m11592)]
    (. bean11591 setRoleName (clojure.core/str v11593)))
   (clojure.core/when-let
    [v11593 (:instance-profile-name m11592)]
    (. bean11591 setInstanceProfileName (clojure.core/str v11593)))
   bean11591))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest}
delete-access-key-request
  [m11595]
  (clojure.core/let
   [bean11594
    (new
     com.amazonaws.services.identitymanagement.model.DeleteAccessKeyRequest)]
   (clojure.core/when-let
    [v11596 (:user-name m11595)]
    (. bean11594 setUserName (clojure.core/str v11596)))
   (clojure.core/when-let
    [v11596 (:access-key-id m11595)]
    (. bean11594 setAccessKeyId (clojure.core/str v11596)))
   bean11594))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteRoleRequest}
delete-role-request
  [m11598]
  (clojure.core/let
   [bean11597
    (new
     com.amazonaws.services.identitymanagement.model.DeleteRoleRequest)]
   (clojure.core/when-let
    [v11599 (:role-name m11598)]
    (. bean11597 setRoleName (clojure.core/str v11599)))
   bean11597))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceRequest}
create-virtual-mfadevice-request
  [m11601]
  (clojure.core/let
   [bean11600
    (new
     com.amazonaws.services.identitymanagement.model.CreateVirtualMFADeviceRequest)]
   (clojure.core/when-let
    [v11602 (:path m11601)]
    (. bean11600 setPath (clojure.core/str v11602)))
   (clojure.core/when-let
    [v11602 (:virtual-mfadevice-name m11601)]
    (. bean11600 setVirtualMFADeviceName (clojure.core/str v11602)))
   bean11600))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListGroupPoliciesRequest}
list-group-policies-request
  [m11604]
  (clojure.core/let
   [bean11603
    (new
     com.amazonaws.services.identitymanagement.model.ListGroupPoliciesRequest)]
   (clojure.core/when-let
    [v11605 (:max-items m11604)]
    (. bean11603 setMaxItems (clojure.core/int v11605)))
   (clojure.core/when-let
    [v11605 (:marker m11604)]
    (. bean11603 setMarker (clojure.core/str v11605)))
   (clojure.core/when-let
    [v11605 (:group-name m11604)]
    (. bean11603 setGroupName (clojure.core/str v11605)))
   bean11603))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetGroupPolicyRequest}
get-group-policy-request
  [m11607]
  (clojure.core/let
   [bean11606
    (new
     com.amazonaws.services.identitymanagement.model.GetGroupPolicyRequest)]
   (clojure.core/when-let
    [v11608 (:policy-name m11607)]
    (. bean11606 setPolicyName (clojure.core/str v11608)))
   (clojure.core/when-let
    [v11608 (:group-name m11607)]
    (. bean11606 setGroupName (clojure.core/str v11608)))
   bean11606))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListServerCertificatesRequest}
list-server-certificates-request
  [m11610]
  (clojure.core/let
   [bean11609
    (new
     com.amazonaws.services.identitymanagement.model.ListServerCertificatesRequest)]
   (clojure.core/when-let
    [v11611 (:max-items m11610)]
    (. bean11609 setMaxItems (clojure.core/int v11611)))
   (clojure.core/when-let
    [v11611 (:marker m11610)]
    (. bean11609 setMarker (clojure.core/str v11611)))
   (clojure.core/when-let
    [v11611 (:path-prefix m11610)]
    (. bean11609 setPathPrefix (clojure.core/str v11611)))
   bean11609))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateAccountPasswordPolicyRequest}
update-account-password-policy-request
  [m11613]
  (clojure.core/let
   [bean11612
    (new
     com.amazonaws.services.identitymanagement.model.UpdateAccountPasswordPolicyRequest)]
   (clojure.core/when-let
    [v11614 (:minimum-password-length m11613)]
    (. bean11612 setMinimumPasswordLength (clojure.core/int v11614)))
   (clojure.core/when-let
    [v11614 (:require-symbols m11613)]
    (. bean11612 setRequireSymbols (clojure.core/boolean v11614)))
   (clojure.core/when-let
    [v11614 (:require-numbers m11613)]
    (. bean11612 setRequireNumbers (clojure.core/boolean v11614)))
   (clojure.core/when-let
    [v11614 (:require-uppercase-characters m11613)]
    (.
     bean11612
     setRequireUppercaseCharacters
     (clojure.core/boolean v11614)))
   (clojure.core/when-let
    [v11614 (:require-lowercase-characters m11613)]
    (.
     bean11612
     setRequireLowercaseCharacters
     (clojure.core/boolean v11614)))
   (clojure.core/when-let
    [v11614 (:allow-users-to-change-password m11613)]
    (.
     bean11612
     setAllowUsersToChangePassword
     (clojure.core/boolean v11614)))
   bean11612))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateGroupRequest}
create-group-request
  [m11616]
  (clojure.core/let
   [bean11615
    (new
     com.amazonaws.services.identitymanagement.model.CreateGroupRequest)]
   (clojure.core/when-let
    [v11617 (:path m11616)]
    (. bean11615 setPath (clojure.core/str v11617)))
   (clojure.core/when-let
    [v11617 (:group-name m11616)]
    (. bean11615 setGroupName (clojure.core/str v11617)))
   bean11615))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleRequest}
list-instance-profiles-for-role-request
  [m11619]
  (clojure.core/let
   [bean11618
    (new
     com.amazonaws.services.identitymanagement.model.ListInstanceProfilesForRoleRequest)]
   (clojure.core/when-let
    [v11620 (:max-items m11619)]
    (. bean11618 setMaxItems (clojure.core/int v11620)))
   (clojure.core/when-let
    [v11620 (:marker m11619)]
    (. bean11618 setMarker (clojure.core/str v11620)))
   (clojure.core/when-let
    [v11620 (:role-name m11619)]
    (. bean11618 setRoleName (clojure.core/str v11620)))
   bean11618))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UploadSigningCertificateRequest}
upload-signing-certificate-request
  [m11622]
  (clojure.core/let
   [bean11621
    (new
     com.amazonaws.services.identitymanagement.model.UploadSigningCertificateRequest)]
   (clojure.core/when-let
    [v11623 (:user-name m11622)]
    (. bean11621 setUserName (clojure.core/str v11623)))
   (clojure.core/when-let
    [v11623 (:certificate-body m11622)]
    (. bean11621 setCertificateBody (clojure.core/str v11623)))
   bean11621))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteServerCertificateRequest}
delete-server-certificate-request
  [m11625]
  (clojure.core/let
   [bean11624
    (new
     com.amazonaws.services.identitymanagement.model.DeleteServerCertificateRequest)]
   (clojure.core/when-let
    [v11626 (:server-certificate-name m11625)]
    (. bean11624 setServerCertificateName (clojure.core/str v11626)))
   bean11624))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListVirtualMFADevicesRequest}
list-virtual-mfadevices-request
  [m11628]
  (clojure.core/let
   [bean11627
    (new
     com.amazonaws.services.identitymanagement.model.ListVirtualMFADevicesRequest)]
   (clojure.core/when-let
    [v11629 (:max-items m11628)]
    (. bean11627 setMaxItems (clojure.core/int v11629)))
   (clojure.core/when-let
    [v11629 (:marker m11628)]
    (. bean11627 setMarker (clojure.core/str v11629)))
   (clojure.core/when-let
    [v11629 (:assignment-status m11628)]
    (.
     bean11627
     setAssignmentStatus
     (identitymanagement/assignment-status-type v11629)))
   bean11627))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest}
remove-role-from-instance-profile-request
  [m11631]
  (clojure.core/let
   [bean11630
    (new
     com.amazonaws.services.identitymanagement.model.RemoveRoleFromInstanceProfileRequest)]
   (clojure.core/when-let
    [v11632 (:role-name m11631)]
    (. bean11630 setRoleName (clojure.core/str v11632)))
   (clojure.core/when-let
    [v11632 (:instance-profile-name m11631)]
    (. bean11630 setInstanceProfileName (clojure.core/str v11632)))
   bean11630))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListSigningCertificatesRequest}
list-signing-certificates-request
  [m11634]
  (clojure.core/let
   [bean11633
    (new
     com.amazonaws.services.identitymanagement.model.ListSigningCertificatesRequest)]
   (clojure.core/when-let
    [v11635 (:max-items m11634)]
    (. bean11633 setMaxItems (clojure.core/int v11635)))
   (clojure.core/when-let
    [v11635 (:marker m11634)]
    (. bean11633 setMarker (clojure.core/str v11635)))
   (clojure.core/when-let
    [v11635 (:user-name m11634)]
    (. bean11633 setUserName (clojure.core/str v11635)))
   bean11633))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileRequest}
delete-instance-profile-request
  [m11637]
  (clojure.core/let
   [bean11636
    (new
     com.amazonaws.services.identitymanagement.model.DeleteInstanceProfileRequest)]
   (clojure.core/when-let
    [v11638 (:instance-profile-name m11637)]
    (. bean11636 setInstanceProfileName (clojure.core/str v11638)))
   bean11636))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListMFADevicesRequest}
list-mfadevices-request
  [m11640]
  (clojure.core/let
   [bean11639
    (new
     com.amazonaws.services.identitymanagement.model.ListMFADevicesRequest)]
   (clojure.core/when-let
    [v11641 (:max-items m11640)]
    (. bean11639 setMaxItems (clojure.core/int v11641)))
   (clojure.core/when-let
    [v11641 (:marker m11640)]
    (. bean11639 setMarker (clojure.core/str v11641)))
   (clojure.core/when-let
    [v11641 (:user-name m11640)]
    (. bean11639 setUserName (clojure.core/str v11641)))
   bean11639))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest}
delete-user-policy-request
  [m11643]
  (clojure.core/let
   [bean11642
    (new
     com.amazonaws.services.identitymanagement.model.DeleteUserPolicyRequest)]
   (clojure.core/when-let
    [v11644 (:policy-name m11643)]
    (. bean11642 setPolicyName (clojure.core/str v11644)))
   (clojure.core/when-let
    [v11644 (:user-name m11643)]
    (. bean11642 setUserName (clojure.core/str v11644)))
   bean11642))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateAccountAliasRequest}
create-account-alias-request
  [m11646]
  (clojure.core/let
   [bean11645
    (new
     com.amazonaws.services.identitymanagement.model.CreateAccountAliasRequest)]
   (clojure.core/when-let
    [v11647 (:account-alias m11646)]
    (. bean11645 setAccountAlias (clojure.core/str v11647)))
   bean11645))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateSigningCertificateRequest}
update-signing-certificate-request
  [m11649]
  (clojure.core/let
   [bean11648
    (new
     com.amazonaws.services.identitymanagement.model.UpdateSigningCertificateRequest)]
   (clojure.core/when-let
    [v11650 (:status m11649)]
    (. bean11648 setStatus (identitymanagement/status-type v11650)))
   (clojure.core/when-let
    [v11650 (:user-name m11649)]
    (. bean11648 setUserName (clojure.core/str v11650)))
   (clojure.core/when-let
    [v11650 (:certificate-id m11649)]
    (. bean11648 setCertificateId (clojure.core/str v11650)))
   bean11648))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateAssumeRolePolicyRequest}
update-assume-role-policy-request
  [m11652]
  (clojure.core/let
   [bean11651
    (new
     com.amazonaws.services.identitymanagement.model.UpdateAssumeRolePolicyRequest)]
   (clojure.core/when-let
    [v11653 (:policy-document m11652)]
    (. bean11651 setPolicyDocument (clojure.core/str v11653)))
   (clojure.core/when-let
    [v11653 (:role-name m11652)]
    (. bean11651 setRoleName (clojure.core/str v11653)))
   bean11651))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListRolesRequest}
list-roles-request
  [m11655]
  (clojure.core/let
   [bean11654
    (new
     com.amazonaws.services.identitymanagement.model.ListRolesRequest)]
   (clojure.core/when-let
    [v11656 (:max-items m11655)]
    (. bean11654 setMaxItems (clojure.core/int v11656)))
   (clojure.core/when-let
    [v11656 (:marker m11655)]
    (. bean11654 setMarker (clojure.core/str v11656)))
   (clojure.core/when-let
    [v11656 (:path-prefix m11655)]
    (. bean11654 setPathPrefix (clojure.core/str v11656)))
   bean11654))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest}
list-user-policies-request
  [m11658]
  (clojure.core/let
   [bean11657
    (new
     com.amazonaws.services.identitymanagement.model.ListUserPoliciesRequest)]
   (clojure.core/when-let
    [v11659 (:max-items m11658)]
    (. bean11657 setMaxItems (clojure.core/int v11659)))
   (clojure.core/when-let
    [v11659 (:marker m11658)]
    (. bean11657 setMarker (clojure.core/str v11659)))
   (clojure.core/when-let
    [v11659 (:user-name m11658)]
    (. bean11657 setUserName (clojure.core/str v11659)))
   bean11657))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteLoginProfileRequest}
delete-login-profile-request
  [m11661]
  (clojure.core/let
   [bean11660
    (new
     com.amazonaws.services.identitymanagement.model.DeleteLoginProfileRequest)]
   (clojure.core/when-let
    [v11662 (:user-name m11661)]
    (. bean11660 setUserName (clojure.core/str v11662)))
   bean11660))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.EnableMFADeviceRequest}
enable-mfadevice-request
  [m11664]
  (clojure.core/let
   [bean11663
    (new
     com.amazonaws.services.identitymanagement.model.EnableMFADeviceRequest)]
   (clojure.core/when-let
    [v11665 (:serial-number m11664)]
    (. bean11663 setSerialNumber (clojure.core/str v11665)))
   (clojure.core/when-let
    [v11665 (:user-name m11664)]
    (. bean11663 setUserName (clojure.core/str v11665)))
   (clojure.core/when-let
    [v11665 (:authentication-code1 m11664)]
    (. bean11663 setAuthenticationCode1 (clojure.core/str v11665)))
   (clojure.core/when-let
    [v11665 (:authentication-code2 m11664)]
    (. bean11663 setAuthenticationCode2 (clojure.core/str v11665)))
   bean11663))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetSAMLProviderRequest}
get-samlprovider-request
  [m11667]
  (clojure.core/let
   [bean11666
    (new
     com.amazonaws.services.identitymanagement.model.GetSAMLProviderRequest)]
   (clojure.core/when-let
    [v11668 (:samlprovider-arn m11667)]
    (. bean11666 setSAMLProviderArn (clojure.core/str v11668)))
   bean11666))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetGroupRequest}
get-group-request
  [m11670]
  (clojure.core/let
   [bean11669
    (new
     com.amazonaws.services.identitymanagement.model.GetGroupRequest)]
   (clojure.core/when-let
    [v11671 (:max-items m11670)]
    (. bean11669 setMaxItems (clojure.core/int v11671)))
   (clojure.core/when-let
    [v11671 (:marker m11670)]
    (. bean11669 setMarker (clojure.core/str v11671)))
   (clojure.core/when-let
    [v11671 (:group-name m11670)]
    (. bean11669 setGroupName (clojure.core/str v11671)))
   bean11669))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.DeleteGroupPolicyRequest}
delete-group-policy-request
  [m11673]
  (clojure.core/let
   [bean11672
    (new
     com.amazonaws.services.identitymanagement.model.DeleteGroupPolicyRequest)]
   (clojure.core/when-let
    [v11674 (:policy-name m11673)]
    (. bean11672 setPolicyName (clojure.core/str v11674)))
   (clojure.core/when-let
    [v11674 (:group-name m11673)]
    (. bean11672 setGroupName (clojure.core/str v11674)))
   bean11672))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest}
create-instance-profile-request
  [m11676]
  (clojure.core/let
   [bean11675
    (new
     com.amazonaws.services.identitymanagement.model.CreateInstanceProfileRequest)]
   (clojure.core/when-let
    [v11677 (:path m11676)]
    (. bean11675 setPath (clojure.core/str v11677)))
   (clojure.core/when-let
    [v11677 (:instance-profile-name m11676)]
    (. bean11675 setInstanceProfileName (clojure.core/str v11677)))
   bean11675))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.UpdateUserRequest}
update-user-request
  [m11679]
  (clojure.core/let
   [bean11678
    (new
     com.amazonaws.services.identitymanagement.model.UpdateUserRequest)]
   (clojure.core/when-let
    [v11680 (:user-name m11679)]
    (. bean11678 setUserName (clojure.core/str v11680)))
   (clojure.core/when-let
    [v11680 (:new-user-name m11679)]
    (. bean11678 setNewUserName (clojure.core/str v11680)))
   (clojure.core/when-let
    [v11680 (:new-path m11679)]
    (. bean11678 setNewPath (clojure.core/str v11680)))
   bean11678))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateUserRequest}
create-user-request
  [m11682]
  (clojure.core/let
   [bean11681
    (new
     com.amazonaws.services.identitymanagement.model.CreateUserRequest)]
   (clojure.core/when-let
    [v11683 (:path m11682)]
    (. bean11681 setPath (clojure.core/str v11683)))
   (clojure.core/when-let
    [v11683 (:user-name m11682)]
    (. bean11681 setUserName (clojure.core/str v11683)))
   bean11681))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.CreateRoleRequest}
create-role-request
  [m11685]
  (clojure.core/let
   [bean11684
    (new
     com.amazonaws.services.identitymanagement.model.CreateRoleRequest)]
   (clojure.core/when-let
    [v11686 (:path m11685)]
    (. bean11684 setPath (clojure.core/str v11686)))
   (clojure.core/when-let
    [v11686 (:role-name m11685)]
    (. bean11684 setRoleName (clojure.core/str v11686)))
   (clojure.core/when-let
    [v11686 (:assume-role-policy-document m11685)]
    (.
     bean11684
     setAssumeRolePolicyDocument
     (clojure.core/str v11686)))
   bean11684))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.GetUserPolicyRequest}
get-user-policy-request
  [m11688]
  (clojure.core/let
   [bean11687
    (new
     com.amazonaws.services.identitymanagement.model.GetUserPolicyRequest)]
   (clojure.core/when-let
    [v11689 (:policy-name m11688)]
    (. bean11687 setPolicyName (clojure.core/str v11689)))
   (clojure.core/when-let
    [v11689 (:user-name m11688)]
    (. bean11687 setUserName (clojure.core/str v11689)))
   bean11687))
 (clojure.core/defn
^{:tag com.amazonaws.services.identitymanagement.model.ListUsersRequest}
list-users-request
  [m11691]
  (clojure.core/let
   [bean11690
    (new
     com.amazonaws.services.identitymanagement.model.ListUsersRequest)]
   (clojure.core/when-let
    [v11692 (:max-items m11691)]
    (. bean11690 setMaxItems (clojure.core/int v11692)))
   (clojure.core/when-let
    [v11692 (:marker m11691)]
    (. bean11690 setMarker (clojure.core/str v11692)))
   (clojure.core/when-let
    [v11692 (:path-prefix m11691)]
    (. bean11690 setPathPrefix (clojure.core/str v11692)))
   bean11690)))
