(ns cerber.http.resource)

(defn roles
  "Returns set of roles assigned to authorized principal"

  [{req :request}]
  (when-let [p (:principal req)]
    (set (.split (get-in p [:subject :roles] "") " ")) #{}))

(defn authorized-resource []
  {:authorized? (comp :authenticated? :request)})

(defn restricted-resource [required-roles]
  {:authorized? (fn [ctx] (every? (roles ctx) required-roles))})
