(ns cerber.system
  (:require [mount.core :refer [defstate] :as mount]
            [clojure.tools.namespace.repl :as tn]
            [cerber.server]))

(defn go
  ([] (mount/start) :ready)
  ([args] (mount/start-with-args args)))

(defn stop []
  (mount/stop))

(defn reset []
  (stop)
  (tn/refresh :after 'cerber.system/go))

(defn refresh []
  (stop)
  (tn/refresh))

(defn refresh-all []
  (stop)
  (tn/refresh-all))

(defn reset
  "Stops all states defined by defstate, reloads modified source files, and restarts the states"
  []
  (stop)
  (tn/refresh :after 'cerber.system/go))
