(ns cerber.routes
  (:require [cerber
             [middleware    :as middleware]
             [gatekeeper    :as gatekeeper]
             [registrar     :as registrar]
             [authenticator :as authenticator]
             [config        :refer [app-config]]]
            [compojure.core :refer [routes]]
            [clojure.tools.logging :as log]))

(defn gatekeeper-routes
  [client config]
  (when config
    (log/info "initializing gatekeeper routes")
    (gatekeeper/init-routes client config)))

(defn authenticator-routes
  [client config]
  (when config
    (log/info "initializing authenticator routes")
    (authenticator/init-routes client config)))

(defn registrar-routes
  [config]
  (when config
    (log/info "initializing registrar routes")
    (registrar/init-routes config)))

(defn cerber-routes
  []
  (let [cerber-stores (gatekeeper/init-stores (:gatekeeper app-config))
        cerber-client (gatekeeper/init-client (:client (:gatekeeper app-config)))
        cerber-routes (apply routes
                             (filter (complement nil?) [(registrar-routes (:registrar app-config))
                                                        (gatekeeper-routes cerber-client (:gatekeeper app-config))
                                                        (authenticator-routes cerber-client (:authenticator app-config))]))]

    (middleware/wrap-api-middleware cerber-routes)))
