(ns cerber.db.schema.recipies
  (:require [clojure.set    :as set]
            [clojure.string :as str]
            [hashids.core   :as hashids]))

(defonce hashid-opts (atom {}))

(def hyphen->underscore
  (fn [v]
    (set/rename-keys v (reduce
                        #(assoc %1 (first %2) (keyword (str/replace (name (first %2)) #"-" "_")))
                        {} v))))

(def underscore->hyphen
  (fn [v]
    (set/rename-keys v (reduce
                        #(assoc %1 (first %2) (keyword (str/replace (name (first %2)) #"_" "-")))
                        {} v))))

(defn encode-hashid
  [v]
  (hashids/encode @hashid-opts v))

(defn decode-hashid
  [s]
  (->> s
       (hashids/decode @hashid-opts)
       first))

(defn transform-fields
  [f fields row]
  (let [xform-fields (clojure.set/intersection
                      (-> row keys set)
                      (set fields))]
    (reduce
     (fn [r field]
       (assoc r field (f (field r))))
     row
     xform-fields)))

(def encode-fields
  (partial transform-fields encode-hashid))

(def decode-fields
  (partial transform-fields decode-hashid))
