(ns cerber.mailer
  (:require [clojure.tools.logging    :as log]
            [timely.core              :as timely]
            [cerber.db.schema.user    :as user]
            [clojurewerkz.mailer.core :refer [delivery-mode! with-delivery-mode with-settings with-defaults with-settings build-email deliver-email]]))

(defn send-confirmation [user {:keys [smtp template]}]
  (log/info "sending email" (:email user))

  (with-settings smtp
    (with-delivery-mode :smtp
      (deliver-email {:from (:from template)
                      :to [(:email user)]
                      :subject (:subject template)}
                     (:path template) {:name (:login user)}))))

(defn send-to-unconfirmed [mailer-opts]
  (when-let [unconfirmed (user/find-by-confirmation false)]
    (doseq [db-user unconfirmed]
      (send-confirmation db-user mailer-opts)
      (user/update-confirmation-sent-flag (:id db-user) true))))

(defn init-mailer
  [config]

  (timely/start-scheduler)
  (let [item (timely/scheduled-item (timely/every 1 :minutes) (partial send-to-unconfirmed config))]
    (timely/start-schedule item)))

(defn stop-mailer
  [sched-id]

  (timely/end-schedule sched-id)
  (.stop timely/SCHEDULER))
