(ns cerber.db.schema.client
  (:require [cerber.db.schema.recipies :refer :all]
            [korma.core :refer :all :rename {update sql-update}]))

(defentity clients
  (prepare hyphen->underscore)
  (transform underscore->hyphen)

  (pk :client_id)
  (entity-fields :client_id :client_secret :name :url))

(defn find-by-client-id [id]
  (first (select clients
                 (fields :client_id :client_secret)
                 (where {:client_id id}))))

(defn create-client [client]
  (insert clients (values client)))

(defn remove-client [client]
  (delete clients (where {:client_id (:client-id client)})))

(defn find-clients []
  (select clients))
