(ns cerber.server
  (:require [cerber
             [middleware    :as middleware]
             [gatekeeper    :as gatekeeper]
             [registrar     :as registrar]
             [authenticator :as authenticator]
             [routes        :as routes]
             [config        :refer [app-config]]]
            [cerber.http.response  :as response]
            [ring.util.response    :refer [redirect]]
            [mount.core            :refer [defstate] :as mount]
            [compojure.core        :refer [GET defroutes routes]]
            [compojure.route       :as route]
            [immutant.web          :as web]
            [clojure.tools.logging :as log]
            [selmer.parser         :as selmer]))

(defroutes static-routes
  (GET "/index.html" {c :context} (selmer/render-file "index.html" c))
  (GET "/" {c :context} (redirect (str c "/index.html")))

  (route/resources "/vendor"  {:root "vendor"})
  (route/resources "/styles"  {:root "styles"})
  (route/resources "/scripts" {:root "scripts"})

  ;; for dev environment
  (route/resources "/bower_components" {:root ""})
  (route/resources "/target/cerber"    {:root "cerber"})

  (route/resources "/")
  (route/not-found "Not Found"))

(defn cerber-app
  [config]

  (selmer/set-resource-path! (clojure.java.io/resource "templates"))
  (if (:is-dev? config) (selmer/cache-off!))

  (middleware/wrap-middlewares (routes
                                (routes/cerber-routes config) static-routes)
                               (:is-dev? config)))

(defstate server
  :start (web/run (cerber-app app-config) (:instance (:server app-config)))
  :stop  (web/stop))
