(ns cerber.routes
  (:require [cerber
             [middleware    :as middleware]
             [gatekeeper    :as gatekeeper]
             [registrar     :as registrar]
             [authenticator :as authenticator]]
            [compojure.core :refer [routes]]
            [clojure.tools.logging :as log]))

(defn gatekeeper-routes
  [client config]
  (when config
    (log/info "initializing gatekeeper routes")
    (gatekeeper/init-routes client config)))

(defn authenticator-routes
  [client config]
  (when config
    (log/info "initializing authenticator routes")
    (authenticator/init-routes client config)))

(defn registrar-routes
  [config]
  (when config
    (log/info "initializing registrar routes")
    (registrar/init-routes config)))

(defn cerber-routes
  [config]
  (let [cookie-config (get-in config [:server :cookie])
        cerber-stores (gatekeeper/init-stores (:gatekeeper config))
        cerber-client (gatekeeper/init-client (:client (:gatekeeper config)))
        cerber-routes (routes (registrar-routes (:registrar config))
                              (gatekeeper-routes cerber-client (:gatekeeper config))
                              (authenticator-routes cerber-client (:authenticator config)))]

    (middleware/wrap-api-middleware cerber-routes cookie-config)))
