(ns cerber.db.schema.user
  (:require [cerber.db.schema.recipies :refer :all]
            [clojure.tools.logging :as log]
            [korma.core :refer :all :rename {update sql-update}]))

(defentity users
  (prepare (partial decode-fields [:id]))
  (transform (partial encode-fields [:id]))

  (pk :id)
  (entity-fields :id :login :name :roles :oid))

(defn find-by-hashid [hashid]
  (first (select users
                 (fields :password :is_active)
                 (where {:id (decode-hashid hashid)}))))

(defn find-by-login [login]
  (first (select users
                 (fields :password :is_active)
                 (where {:login login}))))

(defn find-by-oid [oid]
  (first (select users
                 (where {:oid oid}))))

(defn find-by-confirmation [confirmation-sent?]
  (select users
          (fields [:email])
          (where {:is_confirmed false
                  :is_confirmation_sent confirmation-sent?})))

(defn update-confirmation-sent-flag [hashid confirmation-sent?]
  (sql-update users
          (set-fields {:is_confirmation_sent confirmation-sent?})
          (where {:id (decode-hashid hashid)})))

(defn create-user [user]
  (insert users (values user)))

(defn remove-user [user]
  (delete users (where {:login (:login user)})))

(defn find-users []
  (select users))
