(ns
 pandect.algo.sha384
 "SHA-384 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1291 (compute-sha3841286 [data1289]))
  (clojure.core/doseq
   [v__186__auto__ [#'G__1291 #'compute-sha3841286]]
   (clojure.core/alter-meta!
    v__186__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1291
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha3841286
    [data1289]
    (clojure.core/let
     [md__668__auto__
      (java.security.MessageDigest/getInstance "SHA-384")]
     (.digest md__668__auto__ data1289)))
   java.lang.String
   (compute-sha3841286
    [data1289]
    (clojure.core/let
     [data1289 (.getBytes data1289 "UTF-8")]
     (clojure.core/let
      [md__668__auto__
       (java.security.MessageDigest/getInstance "SHA-384")]
      (.digest md__668__auto__ data1289)))))
  (clojure.core/extend-protocol
   G__1291
   java.io.InputStream
   (compute-sha3841286
    [data1289]
    (clojure.core/let
     [md__669__auto__
      (java.security.MessageDigest/getInstance "SHA-384")
      c__670__auto__
      (clojure.core/int *buffer-size*)
      buf__671__auto__
      (clojure.core/byte-array c__670__auto__)
      s__672__auto__
      data1289]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__673__auto__
        (.read s__672__auto__ buf__671__auto__ 0 c__670__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__673__auto__ -1)
        (.update md__669__auto__ buf__671__auto__ 0 r__673__auto__)
        (recur))))
     (.digest md__669__auto__)))
   java.io.File
   (compute-sha3841286
    [data1289]
    (clojure.core/with-open
     [data1289 (clojure.java.io/input-stream data1289)]
     (clojure.core/let
      [md__669__auto__
       (java.security.MessageDigest/getInstance "SHA-384")
       c__670__auto__
       (clojure.core/int *buffer-size*)
       buf__671__auto__
       (clojure.core/byte-array c__670__auto__)
       s__672__auto__
       data1289]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__673__auto__
         (.read s__672__auto__ buf__671__auto__ 0 c__670__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__673__auto__ -1)
         (.update md__669__auto__ buf__671__auto__ 0 r__673__auto__)
         (recur))))
      (.digest md__669__auto__)))))
  'G__1291)
 (do
  (clojure.core/defn
   sha384*
   "[Hash] SHA-384 (raw value)"
   [x]
   (compute-sha3841286 x))
  (clojure.core/defn
   sha384-file*
   "[Hash] SHA-384 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841286 x)))
  (clojure.core/defn
   sha384-bytes
   "[Hash] SHA-384 (value -> byte array)"
   [x]
   (compute-sha3841286 x))
  (clojure.core/defn
   sha384-file-bytes
   "[Hash] SHA-384 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841286 x)))
  (clojure.core/defn
   sha384
   "[Hash] SHA-384 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-sha3841286 x)))
  (clojure.core/defn
   sha384-file
   "[Hash] SHA-384 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-sha3841286 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1317
   (compute-sha3841314 [data1315 key1316]))
  (clojure.core/doseq
   [v__186__auto__ [#'G__1317 #'compute-sha3841314]]
   (clojure.core/alter-meta!
    v__186__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1317
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha3841314
    [data1315 key1316]
    (clojure.core/let
     [mac__543__auto__
      (javax.crypto.Mac/getInstance "HmacSHA384")
      msg__544__auto__
      (clojure.core/bytes data1315)
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1316 "HmacSHA384")]
     (clojure.core/->
      (clojure.core/doto
       mac__543__auto__
       (.init k__545__auto__)
       (.update msg__544__auto__))
      (.doFinal))))
   java.lang.String
   (compute-sha3841314
    [data1315 key1316]
    (clojure.core/let
     [data1315 (.getBytes data1315 "UTF-8")]
     (clojure.core/let
      [mac__543__auto__
       (javax.crypto.Mac/getInstance "HmacSHA384")
       msg__544__auto__
       (clojure.core/bytes data1315)
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1316 "HmacSHA384")]
      (clojure.core/->
       (clojure.core/doto
        mac__543__auto__
        (.init k__545__auto__)
        (.update msg__544__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1317
   java.io.InputStream
   (compute-sha3841314
    [data1315 key1316]
    (clojure.core/let
     [mac__546__auto__
      (javax.crypto.Mac/getInstance "HmacSHA384")
      k__547__auto__
      (javax.crypto.spec.SecretKeySpec. key1316 "HmacSHA384")
      c__548__auto__
      (clojure.core/int *buffer-size*)
      buf__549__auto__
      (clojure.core/byte-array c__548__auto__)
      s__550__auto__
      data1315]
     (.init mac__546__auto__ k__547__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__551__auto__
        (.read s__550__auto__ buf__549__auto__ 0 c__548__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__551__auto__ -1)
        (.update mac__546__auto__ buf__549__auto__ 0 r__551__auto__)
        (recur))))
     (.doFinal mac__546__auto__)))
   java.io.File
   (compute-sha3841314
    [data1315 key1316]
    (clojure.core/with-open
     [data1315 (clojure.java.io/input-stream data1315)]
     (clojure.core/let
      [mac__546__auto__
       (javax.crypto.Mac/getInstance "HmacSHA384")
       k__547__auto__
       (javax.crypto.spec.SecretKeySpec. key1316 "HmacSHA384")
       c__548__auto__
       (clojure.core/int *buffer-size*)
       buf__549__auto__
       (clojure.core/byte-array c__548__auto__)
       s__550__auto__
       data1315]
      (.init mac__546__auto__ k__547__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__551__auto__
         (.read s__550__auto__ buf__549__auto__ 0 c__548__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__551__auto__ -1)
         (.update mac__546__auto__ buf__549__auto__ 0 r__551__auto__)
         (recur))))
      (.doFinal mac__546__auto__)))))
  'G__1317)
 (do
  (clojure.core/defn
   sha384-hmac*
   "[HMAC] HmacSHA384 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha3841314
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha384-hmac-file*
   "[HMAC] HmacSHA384 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841314
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha384-hmac-bytes
   "[HMAC] HmacSHA384 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-sha3841314
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   sha384-hmac-file-bytes
   "[HMAC] HmacSHA384 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841314
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha384-hmac
   "[HMAC] HmacSHA384 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-sha3841314
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   sha384-hmac-file
   "[HMAC] HmacSHA384 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha3841314
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
(do
 (do
  (clojure.core/defprotocol
   G__1337
   (compute-sha3841333 [data1334 key1336])
   (compute-sha3841333-verify [data1334 sig1335 key1336]))
  (clojure.core/doseq
   [v__186__auto__
    [#'G__1337 #'compute-sha3841333 #'compute-sha3841333-verify]]
   (clojure.core/alter-meta!
    v__186__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1337
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-sha3841333
    [data1334 key1336]
    (clojure.core/let
     [signer__847__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA384withRSA")
       (.initSign key1336)
       (.update (clojure.core/bytes data1334)))]
     (.sign signer__847__auto__)))
   (compute-sha3841333-verify
    [data1334 sig1335 key1336]
    (clojure.core/let
     [signer__848__auto__
      (java.security.Signature/getInstance "SHA384withRSA")
      key__849__auto__
      (pandect.utils.convert/as-public-key key1336)]
     (.initVerify signer__848__auto__ key__849__auto__)
     (.update signer__848__auto__ (clojure.core/bytes data1334))
     (.verify signer__848__auto__ (clojure.core/bytes sig1335))))
   java.lang.String
   (compute-sha3841333
    [data1334 key1336]
    (clojure.core/let
     [data1334 (.getBytes data1334 "UTF-8")]
     (clojure.core/let
      [signer__847__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA384withRSA")
        (.initSign key1336)
        (.update (clojure.core/bytes data1334)))]
      (.sign signer__847__auto__))))
   (compute-sha3841333-verify
    [data1334 sig1335 key1336]
    (clojure.core/let
     [data1334 (.getBytes data1334 "UTF-8")]
     (clojure.core/let
      [signer__848__auto__
       (java.security.Signature/getInstance "SHA384withRSA")
       key__849__auto__
       (pandect.utils.convert/as-public-key key1336)]
      (.initVerify signer__848__auto__ key__849__auto__)
      (.update signer__848__auto__ (clojure.core/bytes data1334))
      (.verify signer__848__auto__ (clojure.core/bytes sig1335))))))
  (clojure.core/extend-protocol
   G__1337
   java.io.InputStream
   (compute-sha3841333
    [data1334 key1336]
    (clojure.core/let
     [signer__850__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "SHA384withRSA")
       (.initSign key1336))
      c__851__auto__
      (clojure.core/int *buffer-size*)
      buf__852__auto__
      (clojure.core/byte-array c__851__auto__)
      s__853__auto__
      data1334]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__854__auto__
        (.read s__853__auto__ buf__852__auto__ 0 c__851__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__854__auto__ -1)
        (.update signer__850__auto__ buf__852__auto__ 0 r__854__auto__)
        (recur))))
     (.sign signer__850__auto__)))
   (compute-sha3841333-verify
    [data1334 sig1335 key1336]
    (clojure.core/let
     [signer__855__auto__
      (java.security.Signature/getInstance "SHA384withRSA")
      c__856__auto__
      (clojure.core/int *buffer-size*)
      buf__857__auto__
      (clojure.core/byte-array c__856__auto__)
      s__858__auto__
      data1334
      key__859__auto__
      (pandect.utils.convert/as-public-key key1336)]
     (.initVerify signer__855__auto__ key__859__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__860__auto__
        (.read s__858__auto__ buf__857__auto__ 0 c__856__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__860__auto__ -1)
        (.update signer__855__auto__ buf__857__auto__ 0 r__860__auto__)
        (recur))))
     (.verify signer__855__auto__ (clojure.core/bytes sig1335))))
   java.io.File
   (compute-sha3841333
    [data1334 key1336]
    (clojure.core/with-open
     [data1334 (clojure.java.io/input-stream data1334)]
     (clojure.core/let
      [signer__850__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "SHA384withRSA")
        (.initSign key1336))
       c__851__auto__
       (clojure.core/int *buffer-size*)
       buf__852__auto__
       (clojure.core/byte-array c__851__auto__)
       s__853__auto__
       data1334]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__854__auto__
         (.read s__853__auto__ buf__852__auto__ 0 c__851__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__854__auto__ -1)
         (.update
          signer__850__auto__
          buf__852__auto__
          0
          r__854__auto__)
         (recur))))
      (.sign signer__850__auto__))))
   (compute-sha3841333-verify
    [data1334 sig1335 key1336]
    (clojure.core/with-open
     [data1334 (clojure.java.io/input-stream data1334)]
     (clojure.core/let
      [signer__855__auto__
       (java.security.Signature/getInstance "SHA384withRSA")
       c__856__auto__
       (clojure.core/int *buffer-size*)
       buf__857__auto__
       (clojure.core/byte-array c__856__auto__)
       s__858__auto__
       data1334
       key__859__auto__
       (pandect.utils.convert/as-public-key key1336)]
      (.initVerify signer__855__auto__ key__859__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__860__auto__
         (.read s__858__auto__ buf__857__auto__ 0 c__856__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__860__auto__ -1)
         (.update
          signer__855__auto__
          buf__857__auto__
          0
          r__860__auto__)
         (recur))))
      (.verify signer__855__auto__ (clojure.core/bytes sig1335))))))
  'G__1337)
 (do
  (clojure.core/defn
   sha384-rsa*
   "[Signature] SHA384withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha3841333 x private-key))
  (clojure.core/defn
   sha384-rsa-file*
   "[Signature] SHA384withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841333 x private-key)))
  (clojure.core/defn
   sha384-rsa-bytes
   "[Signature] SHA384withRSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-sha3841333 x private-key))
  (clojure.core/defn
   sha384-rsa-file-bytes
   "[Signature] SHA384withRSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841333 x private-key)))
  (clojure.core/defn
   sha384-rsa
   "[Signature] SHA384withRSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex
    (compute-sha3841333 x private-key)))
  (clojure.core/defn
   sha384-rsa-file
   "[Signature] SHA384withRSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-sha3841333 x private-key))))
  (clojure.core/defn
   sha384-rsa-verify
   "[Signature] SHA384withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-sha3841333-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   sha384-rsa-verify-file
   "[Signature] SHA384withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-sha3841333-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
