(ns
 pandect.algo.md5
 "MD5 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1234 (compute-md51232 [data1233]))
  (clojure.core/doseq
   [v__186__auto__ [#'G__1234 #'compute-md51232]]
   (clojure.core/alter-meta!
    v__186__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1234
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md51232
    [data1233]
    (clojure.core/let
     [md__668__auto__ (java.security.MessageDigest/getInstance "MD5")]
     (.digest md__668__auto__ data1233)))
   java.lang.String
   (compute-md51232
    [data1233]
    (clojure.core/let
     [data1233 (.getBytes data1233 "UTF-8")]
     (clojure.core/let
      [md__668__auto__ (java.security.MessageDigest/getInstance "MD5")]
      (.digest md__668__auto__ data1233)))))
  (clojure.core/extend-protocol
   G__1234
   java.io.InputStream
   (compute-md51232
    [data1233]
    (clojure.core/let
     [md__669__auto__
      (java.security.MessageDigest/getInstance "MD5")
      c__670__auto__
      (clojure.core/int *buffer-size*)
      buf__671__auto__
      (clojure.core/byte-array c__670__auto__)
      s__672__auto__
      data1233]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__673__auto__
        (.read s__672__auto__ buf__671__auto__ 0 c__670__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__673__auto__ -1)
        (.update md__669__auto__ buf__671__auto__ 0 r__673__auto__)
        (recur))))
     (.digest md__669__auto__)))
   java.io.File
   (compute-md51232
    [data1233]
    (clojure.core/with-open
     [data1233 (clojure.java.io/input-stream data1233)]
     (clojure.core/let
      [md__669__auto__
       (java.security.MessageDigest/getInstance "MD5")
       c__670__auto__
       (clojure.core/int *buffer-size*)
       buf__671__auto__
       (clojure.core/byte-array c__670__auto__)
       s__672__auto__
       data1233]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__673__auto__
         (.read s__672__auto__ buf__671__auto__ 0 c__670__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__673__auto__ -1)
         (.update md__669__auto__ buf__671__auto__ 0 r__673__auto__)
         (recur))))
      (.digest md__669__auto__)))))
  'G__1234)
 (do
  (clojure.core/defn
   md5*
   "[Hash] MD5 (raw value)"
   [x]
   (compute-md51232 x))
  (clojure.core/defn
   md5-file*
   "[Hash] MD5 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51232 x)))
  (clojure.core/defn
   md5-bytes
   "[Hash] MD5 (value -> byte array)"
   [x]
   (compute-md51232 x))
  (clojure.core/defn
   md5-file-bytes
   "[Hash] MD5 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51232 x)))
  (clojure.core/defn
   md5
   "[Hash] MD5 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-md51232 x)))
  (clojure.core/defn
   md5-file
   "[Hash] MD5 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-md51232 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1238
   (compute-md51235 [data1236 key1237]))
  (clojure.core/doseq
   [v__186__auto__ [#'G__1238 #'compute-md51235]]
   (clojure.core/alter-meta!
    v__186__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1238
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md51235
    [data1236 key1237]
    (clojure.core/let
     [mac__543__auto__
      (javax.crypto.Mac/getInstance "HmacMD5")
      msg__544__auto__
      (clojure.core/bytes data1236)
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1237 "HmacMD5")]
     (clojure.core/->
      (clojure.core/doto
       mac__543__auto__
       (.init k__545__auto__)
       (.update msg__544__auto__))
      (.doFinal))))
   java.lang.String
   (compute-md51235
    [data1236 key1237]
    (clojure.core/let
     [data1236 (.getBytes data1236 "UTF-8")]
     (clojure.core/let
      [mac__543__auto__
       (javax.crypto.Mac/getInstance "HmacMD5")
       msg__544__auto__
       (clojure.core/bytes data1236)
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1237 "HmacMD5")]
      (clojure.core/->
       (clojure.core/doto
        mac__543__auto__
        (.init k__545__auto__)
        (.update msg__544__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1238
   java.io.InputStream
   (compute-md51235
    [data1236 key1237]
    (clojure.core/let
     [mac__546__auto__
      (javax.crypto.Mac/getInstance "HmacMD5")
      k__547__auto__
      (javax.crypto.spec.SecretKeySpec. key1237 "HmacMD5")
      c__548__auto__
      (clojure.core/int *buffer-size*)
      buf__549__auto__
      (clojure.core/byte-array c__548__auto__)
      s__550__auto__
      data1236]
     (.init mac__546__auto__ k__547__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__551__auto__
        (.read s__550__auto__ buf__549__auto__ 0 c__548__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__551__auto__ -1)
        (.update mac__546__auto__ buf__549__auto__ 0 r__551__auto__)
        (recur))))
     (.doFinal mac__546__auto__)))
   java.io.File
   (compute-md51235
    [data1236 key1237]
    (clojure.core/with-open
     [data1236 (clojure.java.io/input-stream data1236)]
     (clojure.core/let
      [mac__546__auto__
       (javax.crypto.Mac/getInstance "HmacMD5")
       k__547__auto__
       (javax.crypto.spec.SecretKeySpec. key1237 "HmacMD5")
       c__548__auto__
       (clojure.core/int *buffer-size*)
       buf__549__auto__
       (clojure.core/byte-array c__548__auto__)
       s__550__auto__
       data1236]
      (.init mac__546__auto__ k__547__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__551__auto__
         (.read s__550__auto__ buf__549__auto__ 0 c__548__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__551__auto__ -1)
         (.update mac__546__auto__ buf__549__auto__ 0 r__551__auto__)
         (recur))))
      (.doFinal mac__546__auto__)))))
  'G__1238)
 (do
  (clojure.core/defn
   md5-hmac*
   "[HMAC] HmacMD5 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-md51235
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   md5-hmac-file*
   "[HMAC] HmacMD5 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51235
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   md5-hmac-bytes
   "[HMAC] HmacMD5 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-md51235
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   md5-hmac-file-bytes
   "[HMAC] HmacMD5 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51235
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   md5-hmac
   "[HMAC] HmacMD5 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-md51235
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   md5-hmac-file
   "[HMAC] HmacMD5 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-md51235
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
(do
 (do
  (clojure.core/defprotocol
   G__1277
   (compute-md51273 [data1274 key1276])
   (compute-md51273-verify [data1274 sig1275 key1276]))
  (clojure.core/doseq
   [v__186__auto__
    [#'G__1277 #'compute-md51273 #'compute-md51273-verify]]
   (clojure.core/alter-meta!
    v__186__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1277
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md51273
    [data1274 key1276]
    (clojure.core/let
     [signer__847__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "MD5withRSA")
       (.initSign key1276)
       (.update (clojure.core/bytes data1274)))]
     (.sign signer__847__auto__)))
   (compute-md51273-verify
    [data1274 sig1275 key1276]
    (clojure.core/let
     [signer__848__auto__
      (java.security.Signature/getInstance "MD5withRSA")
      key__849__auto__
      (pandect.utils.convert/as-public-key key1276)]
     (.initVerify signer__848__auto__ key__849__auto__)
     (.update signer__848__auto__ (clojure.core/bytes data1274))
     (.verify signer__848__auto__ (clojure.core/bytes sig1275))))
   java.lang.String
   (compute-md51273
    [data1274 key1276]
    (clojure.core/let
     [data1274 (.getBytes data1274 "UTF-8")]
     (clojure.core/let
      [signer__847__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "MD5withRSA")
        (.initSign key1276)
        (.update (clojure.core/bytes data1274)))]
      (.sign signer__847__auto__))))
   (compute-md51273-verify
    [data1274 sig1275 key1276]
    (clojure.core/let
     [data1274 (.getBytes data1274 "UTF-8")]
     (clojure.core/let
      [signer__848__auto__
       (java.security.Signature/getInstance "MD5withRSA")
       key__849__auto__
       (pandect.utils.convert/as-public-key key1276)]
      (.initVerify signer__848__auto__ key__849__auto__)
      (.update signer__848__auto__ (clojure.core/bytes data1274))
      (.verify signer__848__auto__ (clojure.core/bytes sig1275))))))
  (clojure.core/extend-protocol
   G__1277
   java.io.InputStream
   (compute-md51273
    [data1274 key1276]
    (clojure.core/let
     [signer__850__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "MD5withRSA")
       (.initSign key1276))
      c__851__auto__
      (clojure.core/int *buffer-size*)
      buf__852__auto__
      (clojure.core/byte-array c__851__auto__)
      s__853__auto__
      data1274]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__854__auto__
        (.read s__853__auto__ buf__852__auto__ 0 c__851__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__854__auto__ -1)
        (.update signer__850__auto__ buf__852__auto__ 0 r__854__auto__)
        (recur))))
     (.sign signer__850__auto__)))
   (compute-md51273-verify
    [data1274 sig1275 key1276]
    (clojure.core/let
     [signer__855__auto__
      (java.security.Signature/getInstance "MD5withRSA")
      c__856__auto__
      (clojure.core/int *buffer-size*)
      buf__857__auto__
      (clojure.core/byte-array c__856__auto__)
      s__858__auto__
      data1274
      key__859__auto__
      (pandect.utils.convert/as-public-key key1276)]
     (.initVerify signer__855__auto__ key__859__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__860__auto__
        (.read s__858__auto__ buf__857__auto__ 0 c__856__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__860__auto__ -1)
        (.update signer__855__auto__ buf__857__auto__ 0 r__860__auto__)
        (recur))))
     (.verify signer__855__auto__ (clojure.core/bytes sig1275))))
   java.io.File
   (compute-md51273
    [data1274 key1276]
    (clojure.core/with-open
     [data1274 (clojure.java.io/input-stream data1274)]
     (clojure.core/let
      [signer__850__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "MD5withRSA")
        (.initSign key1276))
       c__851__auto__
       (clojure.core/int *buffer-size*)
       buf__852__auto__
       (clojure.core/byte-array c__851__auto__)
       s__853__auto__
       data1274]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__854__auto__
         (.read s__853__auto__ buf__852__auto__ 0 c__851__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__854__auto__ -1)
         (.update
          signer__850__auto__
          buf__852__auto__
          0
          r__854__auto__)
         (recur))))
      (.sign signer__850__auto__))))
   (compute-md51273-verify
    [data1274 sig1275 key1276]
    (clojure.core/with-open
     [data1274 (clojure.java.io/input-stream data1274)]
     (clojure.core/let
      [signer__855__auto__
       (java.security.Signature/getInstance "MD5withRSA")
       c__856__auto__
       (clojure.core/int *buffer-size*)
       buf__857__auto__
       (clojure.core/byte-array c__856__auto__)
       s__858__auto__
       data1274
       key__859__auto__
       (pandect.utils.convert/as-public-key key1276)]
      (.initVerify signer__855__auto__ key__859__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__860__auto__
         (.read s__858__auto__ buf__857__auto__ 0 c__856__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__860__auto__ -1)
         (.update
          signer__855__auto__
          buf__857__auto__
          0
          r__860__auto__)
         (recur))))
      (.verify signer__855__auto__ (clojure.core/bytes sig1275))))))
  'G__1277)
 (do
  (clojure.core/defn
   md5-rsa*
   "[Signature] MD5withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-md51273 x private-key))
  (clojure.core/defn
   md5-rsa-file*
   "[Signature] MD5withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51273 x private-key)))
  (clojure.core/defn
   md5-rsa-bytes
   "[Signature] MD5withRSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-md51273 x private-key))
  (clojure.core/defn
   md5-rsa-file-bytes
   "[Signature] MD5withRSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51273 x private-key)))
  (clojure.core/defn
   md5-rsa
   "[Signature] MD5withRSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex (compute-md51273 x private-key)))
  (clojure.core/defn
   md5-rsa-file
   "[Signature] MD5withRSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-md51273 x private-key))))
  (clojure.core/defn
   md5-rsa-verify
   "[Signature] MD5withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-md51273-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   md5-rsa-verify-file
   "[Signature] MD5withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md51273-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
