(ns
 pandect.algo.md2
 "MD2 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1206 (compute-md21204 [data1205]))
  (clojure.core/doseq
   [v__186__auto__ [#'G__1206 #'compute-md21204]]
   (clojure.core/alter-meta!
    v__186__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1206
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md21204
    [data1205]
    (clojure.core/let
     [md__668__auto__ (java.security.MessageDigest/getInstance "MD2")]
     (.digest md__668__auto__ data1205)))
   java.lang.String
   (compute-md21204
    [data1205]
    (clojure.core/let
     [data1205 (.getBytes data1205 "UTF-8")]
     (clojure.core/let
      [md__668__auto__ (java.security.MessageDigest/getInstance "MD2")]
      (.digest md__668__auto__ data1205)))))
  (clojure.core/extend-protocol
   G__1206
   java.io.InputStream
   (compute-md21204
    [data1205]
    (clojure.core/let
     [md__669__auto__
      (java.security.MessageDigest/getInstance "MD2")
      c__670__auto__
      (clojure.core/int *buffer-size*)
      buf__671__auto__
      (clojure.core/byte-array c__670__auto__)
      s__672__auto__
      data1205]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__673__auto__
        (.read s__672__auto__ buf__671__auto__ 0 c__670__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__673__auto__ -1)
        (.update md__669__auto__ buf__671__auto__ 0 r__673__auto__)
        (recur))))
     (.digest md__669__auto__)))
   java.io.File
   (compute-md21204
    [data1205]
    (clojure.core/with-open
     [data1205 (clojure.java.io/input-stream data1205)]
     (clojure.core/let
      [md__669__auto__
       (java.security.MessageDigest/getInstance "MD2")
       c__670__auto__
       (clojure.core/int *buffer-size*)
       buf__671__auto__
       (clojure.core/byte-array c__670__auto__)
       s__672__auto__
       data1205]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__673__auto__
         (.read s__672__auto__ buf__671__auto__ 0 c__670__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__673__auto__ -1)
         (.update md__669__auto__ buf__671__auto__ 0 r__673__auto__)
         (recur))))
      (.digest md__669__auto__)))))
  'G__1206)
 (do
  (clojure.core/defn
   md2*
   "[Hash] MD2 (raw value)"
   [x]
   (compute-md21204 x))
  (clojure.core/defn
   md2-file*
   "[Hash] MD2 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md21204 x)))
  (clojure.core/defn
   md2-bytes
   "[Hash] MD2 (value -> byte array)"
   [x]
   (compute-md21204 x))
  (clojure.core/defn
   md2-file-bytes
   "[Hash] MD2 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md21204 x)))
  (clojure.core/defn
   md2
   "[Hash] MD2 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-md21204 x)))
  (clojure.core/defn
   md2-file
   "[Hash] MD2 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-md21204 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1231
   (compute-md21227 [data1228 key1230])
   (compute-md21227-verify [data1228 sig1229 key1230]))
  (clojure.core/doseq
   [v__186__auto__
    [#'G__1231 #'compute-md21227 #'compute-md21227-verify]]
   (clojure.core/alter-meta!
    v__186__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1231
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-md21227
    [data1228 key1230]
    (clojure.core/let
     [signer__847__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "MD2withRSA")
       (.initSign key1230)
       (.update (clojure.core/bytes data1228)))]
     (.sign signer__847__auto__)))
   (compute-md21227-verify
    [data1228 sig1229 key1230]
    (clojure.core/let
     [signer__848__auto__
      (java.security.Signature/getInstance "MD2withRSA")
      key__849__auto__
      (pandect.utils.convert/as-public-key key1230)]
     (.initVerify signer__848__auto__ key__849__auto__)
     (.update signer__848__auto__ (clojure.core/bytes data1228))
     (.verify signer__848__auto__ (clojure.core/bytes sig1229))))
   java.lang.String
   (compute-md21227
    [data1228 key1230]
    (clojure.core/let
     [data1228 (.getBytes data1228 "UTF-8")]
     (clojure.core/let
      [signer__847__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "MD2withRSA")
        (.initSign key1230)
        (.update (clojure.core/bytes data1228)))]
      (.sign signer__847__auto__))))
   (compute-md21227-verify
    [data1228 sig1229 key1230]
    (clojure.core/let
     [data1228 (.getBytes data1228 "UTF-8")]
     (clojure.core/let
      [signer__848__auto__
       (java.security.Signature/getInstance "MD2withRSA")
       key__849__auto__
       (pandect.utils.convert/as-public-key key1230)]
      (.initVerify signer__848__auto__ key__849__auto__)
      (.update signer__848__auto__ (clojure.core/bytes data1228))
      (.verify signer__848__auto__ (clojure.core/bytes sig1229))))))
  (clojure.core/extend-protocol
   G__1231
   java.io.InputStream
   (compute-md21227
    [data1228 key1230]
    (clojure.core/let
     [signer__850__auto__
      (clojure.core/doto
       (java.security.Signature/getInstance "MD2withRSA")
       (.initSign key1230))
      c__851__auto__
      (clojure.core/int *buffer-size*)
      buf__852__auto__
      (clojure.core/byte-array c__851__auto__)
      s__853__auto__
      data1228]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__854__auto__
        (.read s__853__auto__ buf__852__auto__ 0 c__851__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__854__auto__ -1)
        (.update signer__850__auto__ buf__852__auto__ 0 r__854__auto__)
        (recur))))
     (.sign signer__850__auto__)))
   (compute-md21227-verify
    [data1228 sig1229 key1230]
    (clojure.core/let
     [signer__855__auto__
      (java.security.Signature/getInstance "MD2withRSA")
      c__856__auto__
      (clojure.core/int *buffer-size*)
      buf__857__auto__
      (clojure.core/byte-array c__856__auto__)
      s__858__auto__
      data1228
      key__859__auto__
      (pandect.utils.convert/as-public-key key1230)]
     (.initVerify signer__855__auto__ key__859__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__860__auto__
        (.read s__858__auto__ buf__857__auto__ 0 c__856__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__860__auto__ -1)
        (.update signer__855__auto__ buf__857__auto__ 0 r__860__auto__)
        (recur))))
     (.verify signer__855__auto__ (clojure.core/bytes sig1229))))
   java.io.File
   (compute-md21227
    [data1228 key1230]
    (clojure.core/with-open
     [data1228 (clojure.java.io/input-stream data1228)]
     (clojure.core/let
      [signer__850__auto__
       (clojure.core/doto
        (java.security.Signature/getInstance "MD2withRSA")
        (.initSign key1230))
       c__851__auto__
       (clojure.core/int *buffer-size*)
       buf__852__auto__
       (clojure.core/byte-array c__851__auto__)
       s__853__auto__
       data1228]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__854__auto__
         (.read s__853__auto__ buf__852__auto__ 0 c__851__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__854__auto__ -1)
         (.update
          signer__850__auto__
          buf__852__auto__
          0
          r__854__auto__)
         (recur))))
      (.sign signer__850__auto__))))
   (compute-md21227-verify
    [data1228 sig1229 key1230]
    (clojure.core/with-open
     [data1228 (clojure.java.io/input-stream data1228)]
     (clojure.core/let
      [signer__855__auto__
       (java.security.Signature/getInstance "MD2withRSA")
       c__856__auto__
       (clojure.core/int *buffer-size*)
       buf__857__auto__
       (clojure.core/byte-array c__856__auto__)
       s__858__auto__
       data1228
       key__859__auto__
       (pandect.utils.convert/as-public-key key1230)]
      (.initVerify signer__855__auto__ key__859__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__860__auto__
         (.read s__858__auto__ buf__857__auto__ 0 c__856__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__860__auto__ -1)
         (.update
          signer__855__auto__
          buf__857__auto__
          0
          r__860__auto__)
         (recur))))
      (.verify signer__855__auto__ (clojure.core/bytes sig1229))))))
  'G__1231)
 (do
  (clojure.core/defn
   md2-rsa*
   "[Signature] MD2withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-md21227 x private-key))
  (clojure.core/defn
   md2-rsa-file*
   "[Signature] MD2withRSA (raw value)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md21227 x private-key)))
  (clojure.core/defn
   md2-rsa-bytes
   "[Signature] MD2withRSA (value -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (compute-md21227 x private-key))
  (clojure.core/defn
   md2-rsa-file-bytes
   "[Signature] MD2withRSA (file path -> byte array)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md21227 x private-key)))
  (clojure.core/defn
   md2-rsa
   "[Signature] MD2withRSA (value -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (pandect.utils.convert/bytes->hex (compute-md21227 x private-key)))
  (clojure.core/defn
   md2-rsa-file
   "[Signature] MD2withRSA (file path -> string)\n\nSign the given message using the given java.security.PrivateKey."
   [x private-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-md21227 x private-key))))
  (clojure.core/defn
   md2-rsa-verify
   "[Signature] MD2withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (compute-md21227-verify
    x
    (pandect.utils.convert/convert-signature-to-byte-array signature)
    (pandect.utils.convert/convert-to-public-key public-key)))
  (clojure.core/defn
   md2-rsa-verify-file
   "[Signature] MD2withRSA\n\nVerify the given message signature using the given public key (anything implementing `pandect.utils.convert/PublicKeyConvertable`)\n\nThe signature can be given as a byte array, hex (!) string, java.io.File,\njava.io.InputStream or anything implementing `pandect.utils.convert/ByteConvertable`."
   [x signature public-key]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-md21227-verify
     x
     (pandect.utils.convert/convert-signature-to-byte-array signature)
     (pandect.utils.convert/convert-to-public-key public-key))))))
