(ns
 pandect.algo.keccak-224
 "Keccak-224 algorithm implementation\n\n(requires `org.bouncycastle/bcprov-jdk15on` to be on the classpath)"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]
  pandect.utils.bouncy-castle-provider))
(do
 (do
  (clojure.core/defprotocol
   G__1197
   (compute-keccak-2241195 [data1196]))
  (clojure.core/doseq
   [v__186__auto__ [#'G__1197 #'compute-keccak-2241195]]
   (clojure.core/alter-meta!
    v__186__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1197
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-2241195
    [data1196]
    (clojure.core/let
     [md__668__auto__
      (java.security.MessageDigest/getInstance "Keccak-224")]
     (.digest md__668__auto__ data1196)))
   java.lang.String
   (compute-keccak-2241195
    [data1196]
    (clojure.core/let
     [data1196 (.getBytes data1196 "UTF-8")]
     (clojure.core/let
      [md__668__auto__
       (java.security.MessageDigest/getInstance "Keccak-224")]
      (.digest md__668__auto__ data1196)))))
  (clojure.core/extend-protocol
   G__1197
   java.io.InputStream
   (compute-keccak-2241195
    [data1196]
    (clojure.core/let
     [md__669__auto__
      (java.security.MessageDigest/getInstance "Keccak-224")
      c__670__auto__
      (clojure.core/int *buffer-size*)
      buf__671__auto__
      (clojure.core/byte-array c__670__auto__)
      s__672__auto__
      data1196]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__673__auto__
        (.read s__672__auto__ buf__671__auto__ 0 c__670__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__673__auto__ -1)
        (.update md__669__auto__ buf__671__auto__ 0 r__673__auto__)
        (recur))))
     (.digest md__669__auto__)))
   java.io.File
   (compute-keccak-2241195
    [data1196]
    (clojure.core/with-open
     [data1196 (clojure.java.io/input-stream data1196)]
     (clojure.core/let
      [md__669__auto__
       (java.security.MessageDigest/getInstance "Keccak-224")
       c__670__auto__
       (clojure.core/int *buffer-size*)
       buf__671__auto__
       (clojure.core/byte-array c__670__auto__)
       s__672__auto__
       data1196]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__673__auto__
         (.read s__672__auto__ buf__671__auto__ 0 c__670__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__673__auto__ -1)
         (.update md__669__auto__ buf__671__auto__ 0 r__673__auto__)
         (recur))))
      (.digest md__669__auto__)))))
  'G__1197)
 (do
  (clojure.core/defn
   keccak-224*
   "[Hash] Keccak-224 (raw value)"
   [x]
   (compute-keccak-2241195 x))
  (clojure.core/defn
   keccak-224-file*
   "[Hash] Keccak-224 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2241195 x)))
  (clojure.core/defn
   keccak-224-bytes
   "[Hash] Keccak-224 (value -> byte array)"
   [x]
   (compute-keccak-2241195 x))
  (clojure.core/defn
   keccak-224-file-bytes
   "[Hash] Keccak-224 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2241195 x)))
  (clojure.core/defn
   keccak-224
   "[Hash] Keccak-224 (value -> string)"
   [x]
   (pandect.utils.convert/bytes->hex (compute-keccak-2241195 x)))
  (clojure.core/defn
   keccak-224-file
   "[Hash] Keccak-224 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex (compute-keccak-2241195 x))))))
(do
 (do
  (clojure.core/defprotocol
   G__1222
   (compute-keccak-2241219 [data1220 key1221]))
  (clojure.core/doseq
   [v__186__auto__ [#'G__1222 #'compute-keccak-2241219]]
   (clojure.core/alter-meta!
    v__186__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1222
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-keccak-2241219
    [data1220 key1221]
    (clojure.core/let
     [mac__543__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak224")
      msg__544__auto__
      (clojure.core/bytes data1220)
      k__545__auto__
      (javax.crypto.spec.SecretKeySpec. key1221 "Hmac-Keccak224")]
     (clojure.core/->
      (clojure.core/doto
       mac__543__auto__
       (.init k__545__auto__)
       (.update msg__544__auto__))
      (.doFinal))))
   java.lang.String
   (compute-keccak-2241219
    [data1220 key1221]
    (clojure.core/let
     [data1220 (.getBytes data1220 "UTF-8")]
     (clojure.core/let
      [mac__543__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak224")
       msg__544__auto__
       (clojure.core/bytes data1220)
       k__545__auto__
       (javax.crypto.spec.SecretKeySpec. key1221 "Hmac-Keccak224")]
      (clojure.core/->
       (clojure.core/doto
        mac__543__auto__
        (.init k__545__auto__)
        (.update msg__544__auto__))
       (.doFinal))))))
  (clojure.core/extend-protocol
   G__1222
   java.io.InputStream
   (compute-keccak-2241219
    [data1220 key1221]
    (clojure.core/let
     [mac__546__auto__
      (javax.crypto.Mac/getInstance "Hmac-Keccak224")
      k__547__auto__
      (javax.crypto.spec.SecretKeySpec. key1221 "Hmac-Keccak224")
      c__548__auto__
      (clojure.core/int *buffer-size*)
      buf__549__auto__
      (clojure.core/byte-array c__548__auto__)
      s__550__auto__
      data1220]
     (.init mac__546__auto__ k__547__auto__)
     (clojure.core/loop
      []
      (clojure.core/let
       [r__551__auto__
        (.read s__550__auto__ buf__549__auto__ 0 c__548__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__551__auto__ -1)
        (.update mac__546__auto__ buf__549__auto__ 0 r__551__auto__)
        (recur))))
     (.doFinal mac__546__auto__)))
   java.io.File
   (compute-keccak-2241219
    [data1220 key1221]
    (clojure.core/with-open
     [data1220 (clojure.java.io/input-stream data1220)]
     (clojure.core/let
      [mac__546__auto__
       (javax.crypto.Mac/getInstance "Hmac-Keccak224")
       k__547__auto__
       (javax.crypto.spec.SecretKeySpec. key1221 "Hmac-Keccak224")
       c__548__auto__
       (clojure.core/int *buffer-size*)
       buf__549__auto__
       (clojure.core/byte-array c__548__auto__)
       s__550__auto__
       data1220]
      (.init mac__546__auto__ k__547__auto__)
      (clojure.core/loop
       []
       (clojure.core/let
        [r__551__auto__
         (.read s__550__auto__ buf__549__auto__ 0 c__548__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__551__auto__ -1)
         (.update mac__546__auto__ buf__549__auto__ 0 r__551__auto__)
         (recur))))
      (.doFinal mac__546__auto__)))))
  'G__1222)
 (do
  (clojure.core/defn
   keccak-224-hmac*
   "[HMAC] Hmac-Keccak224 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-2241219
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-224-hmac-file*
   "[HMAC] Hmac-Keccak224 (raw value)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2241219
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-224-hmac-bytes
   "[HMAC] Hmac-Keccak224 (value -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (compute-keccak-2241219
    x
    (pandect.utils.convert/convert-to-byte-array secret)))
  (clojure.core/defn
   keccak-224-hmac-file-bytes
   "[HMAC] Hmac-Keccak224 (file path -> byte array)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-keccak-2241219
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-224-hmac
   "[HMAC] Hmac-Keccak224 (value -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (pandect.utils.convert/bytes->hex
    (compute-keccak-2241219
     x
     (pandect.utils.convert/convert-to-byte-array secret))))
  (clojure.core/defn
   keccak-224-hmac-file
   "[HMAC] Hmac-Keccak224 (file path -> string)\n\n'secret' can be given as a byte array, string, java.io.File, java.io.InputStream\nor any value implementing `pandect.utils.convert/ByteConvertable`."
   [x secret]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/bytes->hex
     (compute-keccak-2241219
      x
      (pandect.utils.convert/convert-to-byte-array secret)))))))
