(ns matthiasn.systems-toolbox.log
                    
  (:require [matthiasn.systems-toolbox.component :as comp]
                                                 ))

       (enable-console-print!)

(defn all-msgs-handler
  "Handle incoming messages: process / add to application state."
  [{:keys [msg msg-meta]}]
                               
         (println "Log: " msg-meta " " msg))

(defn component
  "Creates component for logging, which in this case does not need local state."
  [cmp-id]
  (comp/make-component
    {:cmp-id  cmp-id
     :all-msgs-handler all-msgs-handler
     :msgs-on-firehose false
     :snapshots-on-firehose false}))

;;;;;;;;;;;; This file autogenerated from src/cljx/matthiasn/systems_toolbox/log.cljx
