# systemd-watchdog

## Running Clojure app under systemd

How do you deploy your Clojure applications, and how do you keep them running?
In most recent and relevant Linux
distributions, **[systemd](https://en.wikipedia.org/wiki/Systemd)**
is the default init system, so the easiest thing to do is create a systemd
service to start your application as a service. You can find examples of that
for the services running on my box hosting **[matthiasnehlsen.com](http://matthiasnehlsen.com/)**
and all of the related live examples in this **[repo](https://github.com/matthiasn/conf)**.


## Supervision by systemd




## Usage

Import the library:

    (:require [matthiasn.systemd-watchdog.core :as wd])

Start the watchdog notifier:

    (wd/start-watchdog! 5000)

That's it.


## REPL-driven development

You can call the `start-watchdog!` function in any kind of REPL-driven workflow
as often as you want, it's not going to do anything unless


## Prior artwork

The most important building block here is
the **[SDNotify](https://github.com/faljse/SDNotify)** Java library. This
library is then called inside a
minimal **[systems-toolbox](https://github.com/matthiasn/systems-toolbox)**
system, which can be embedded in any **Clojure** application.


## License

Distributed under the Eclipse Public License either version 1.0 or
(at your option) any later version.
