/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import clojure.lang.IPersistentMap;
import clojure.lang.Keyword;
import clojure.lang.PersistentArrayMap;
import java.util.Map;
import java.util.TreeMap;
import org.httpkit.server.HttpRequest;

class ClojureRing {
    static final Keyword SERVER_PORT = Keyword.intern((String)"server-port");
    static final Keyword SERVER_NAME = Keyword.intern((String)"server-name");
    static final Keyword REMOTE_ADDR = Keyword.intern((String)"remote-addr");
    static final Keyword URI = Keyword.intern((String)"uri");
    static final Keyword QUERY_STRING = Keyword.intern((String)"query-string");
    static final Keyword SCHEME = Keyword.intern((String)"scheme");
    static final Keyword REQUEST_METHOD = Keyword.intern((String)"request-method");
    static final Keyword HEADERS = Keyword.intern((String)"headers");
    static final Keyword CONTENT_TYPE = Keyword.intern((String)"content-type");
    static final Keyword CONTENT_LENGTH = Keyword.intern((String)"content-length");
    static final Keyword CHARACTER_ENCODING = Keyword.intern((String)"character-encoding");
    static final Keyword BODY = Keyword.intern((String)"body");
    static final Keyword WEBSOCKET = Keyword.intern((String)"websocket?");
    static final Keyword ASYC_CHANNEL = Keyword.intern((String)"async-channel");
    static final Keyword HTTP = Keyword.intern((String)"http");
    static final Keyword STATUS = Keyword.intern((String)"status");

    ClojureRing() {
    }

    public static int getStatus(Map<Keyword, Object> resp) {
        int status = 200;
        Object s = resp.get(STATUS);
        if (s instanceof Long) {
            status = ((Long)s).intValue();
        } else if (s instanceof Integer) {
            status = (Integer)s;
        }
        return status;
    }

    public static IPersistentMap buildRequestMap(HttpRequest req) {
        TreeMap<Keyword, Object> m = new TreeMap<Keyword, Object>();
        m.put(SERVER_PORT, req.serverPort);
        m.put(SERVER_NAME, req.serverName);
        m.put(REMOTE_ADDR, req.getRemoteAddr());
        m.put(URI, req.uri);
        m.put(QUERY_STRING, req.queryString);
        m.put(SCHEME, HTTP);
        m.put(ASYC_CHANNEL, req.channel);
        m.put(WEBSOCKET, req.isWebSocket);
        m.put(REQUEST_METHOD, req.method.KEY);
        m.put(HEADERS, PersistentArrayMap.create(req.headers));
        m.put(CONTENT_TYPE, req.contentType);
        m.put(CONTENT_LENGTH, req.contentLength);
        m.put(CHARACTER_ENCODING, req.charset);
        m.put(BODY, req.getBody());
        return PersistentArrayMap.create(m);
    }
}

