(ns matteoredaelli.qliksense.systemrule
  (:require
   [cheshire.core :refer :all]
   [matteoredaelli.qliksense.utils :as utils]
   [matteoredaelli.qliksense.api :as api])
)

(defn systemrule-security-audit-matrix
  "security audit matrix"
  [{:keys [config system url resource-type resource-filter user-filter outfile]}]
  (let [system_map (get-in config [:systems system])
        body {
              :resourceType resource-type
              :resourceRef {
                            :resourceFilter resource-filter
                            }
              :subjectRef {
                           :resourceFilter user-filter
                           }
              :actions 46
              :environmentAttributes ""
              :resourceProperties ["name"]
              :subjectProperties ["name", "userid", "userdirectory", "privileges"]
              :auditLimit 1000
              :outputObjectsPrivileges 7
              }
        resp (api/post-request system_map
                               (str url "/qrs/systemrule/security/audit/matrix")
                               {}
                               body)
        ]
    (utils/out-string (:body resp) outfile)
    ;; (println resp)
    resp
    ))
