(ns matteoredaelli.qliksense.custom-property
  (:require
   [cheshire.core :refer :all]
   [matteoredaelli.qliksense.utils :as utils]
   [matteoredaelli.qliksense.api :as api])
)

(defn update-custom-property-with-new-definitions
  ""
  [source-custom-property new_custom-property-definitions]
  (let [custom-property (dissoc source-custom-property :id)
        name (get-in custom-property [:definition :name])
        filtered-new-definitions (utils/filter-entities-by-name new_custom-property-definitions
                                                              name)
        new-definition {:id (:id (nth filtered-new-definitions 0))
                        :schemaPath "CustomPropertyDefinition"}]
    (assoc custom-property
           :definition new-definition)))

(defn update-custom-properties-with-new-definitions
  ""
  [custom-properties new_custom-property-definitions]
  (map #(update-custom-property-with-new-definitions % new_custom-property-definitions)
       custom-properties))

(defn copy-custom-properties-from-entity
  "copy custom properties fron an other entity and/or update yjem with new custom property defintions"
  ([entity new-custom-property-definitions]
   (copy-custom-properties-from-entity entity entity new-custom-property-definitions))
  ([entity source-entity new-custom-property-definitions]
  (if-not (contains? source-entity :customProperties)
    entity
    ;; else
    (let [new-custom-property-values (update-custom-properties-with-new-definitions
                                      (:customProperties source-entity)
                                      new-custom-property-definitions)]
      (assoc entity :customProperties new-custom-property-values)))))
