(defproject materia/materia-core "0.3.0-SNAPSHOT"
  :description "A collection of reusable components for Clojure web applications"
  :min-lein-version "2.5.2"
  :repl-options {:init-ns materia.repl}
  :dependencies [[org.clojure/clojure "_"]

                 ;; Web
                 [org.immutant/immutant "2.1.1"]
                 [ring/ring-defaults "0.1.5"]
                 [ring/ring-core "1.4.0"]
                 [ring/ring-devel "1.4.0"]
                 [metosin/ring-http-response "0.6.5"]
                 [bidi "1.23.1"]
                 [prone "0.8.2"]
                 [enlive "1.1.6"]

                 ;; Service management
                 [com.stuartsierra/component "0.3.1"]

                 ;; Logging
                 [spootnik/unilog "0.7.13"]
                 [org.clojure/tools.logging "0.3.1"]
                 [io.aviso/pretty "0.1.20"]

                 ;; DB
                 [mysql/mysql-connector-java "5.1.38"]
                 [funcool/clojure.jdbc "0.5.1"]
                 [hikari-cp "1.4.0"]
                 [stch-library/sql "0.1.1"]
                 [clj-liquibase "0.5.3"]

                 ;; misc
                 [bultitude "0.2.8"]
                 [potemkin "0.4.2"]
                 [prismatic/plumbing "0.4.4"]
                 [org.clojure/tools.nrepl "0.2.12"]
                 [org.clojure/tools.namespace "0.2.11"]
                 [rkworks/baum "0.3.0"]
                 [rkworks/cling "0.1.1"]
                 [environ "1.0.1"]
                 [clj-time "0.11.0"]
                 [inflections "0.10.0"]
                 [com.cemerick/url "0.1.1" :exclusions [org.clojure/clojurescript]]]
  :plugins [[lein-environ "1.0.0"]
            [lein-modules "0.3.11"]]
  :profiles {:uberjar {:aot :all}
             :dev {:main materia.main
                   :dependencies [[commons-io "2.4"]
                                  [ring/ring-mock "0.3.0"]
                                  [clj-http "2.0.0"]
                                  [com.h2database/h2 "1.4.190"]]
                   :env          {:dev true}}})
