(ns materia.config
  (:require [baum.core :as b]))

(b/deflazyreader dev-reader [v opts]
  (b/reduction (b/if-reader [(b/env-reader :dev)
                             v])
               opts))

(defn read-config [file]
  (b/read-config file
                 {:shorthand? true
                  :readers {'when-dev dev-reader}}))
