(ns materia.middleware.response
  (:require [environ.core :refer [env]]
            [materia.logging :as log]
            [materia.request :refer [get-request]]
            [materia.response :as res]
            [ring.util.http-status :as s]
            [slingshot.slingshot :as ss]))

(defn- response-exception? [ex]
  (= (:type (ss/get-thrown-object ex)) :ring.util.http-response/response))

(defn- error-body [name description]
  (format "<h1>%s</h1><p>%s</p>" name description))

(defn default-error-handler [req ex]
  (if-let [{:keys [status body] :as res} (and (response-exception? ex)
                                              (:response (ss/get-thrown-object ex)))]
    (if (nil? body)
      (let [{:keys [name description]} (get s/status status)]
        (-> res
            (assoc :body (error-body name description))
            (res/content-type "text/html")))
      res)
    (if (env :dev)
      (throw ex)
      (do
        (let [{:keys [name description]} (get s/status 500)]
          (log/error ex "Uncaught exception")
          (-> (res/internal-server-error (error-body name description))
              (res/content-type "text/html")))))))


(defn wrap-error-handler [h & [error-handler]]
  (fn [req]
    (try
      (h req)
      (catch Throwable e
        ((or error-handler default-error-handler) (or (get-request) req) e)))))
