(ns materia.main
  (:gen-class)
  (:require [cling.core :refer [defcmd defentrypoint defcontainer] :as cli]
            [clojure.java.io :as io]
            [materia.config :refer [read-config]]
            [materia.system :as sys]))

(def global-options
  [["-c" "--config PATH" "Config file"
    :parse-fn io/file
    :default (io/resource "config/config.edn")
    :validate [#(.exists ^java.io.File %)  "File does not exist"
               #(.isFile ^java.io.File %)  "Path is not a regular file"
               #(.canRead ^java.io.File %) "File is unreadable"]
    :default-desc "resource://config/config.edn"]])

(defcmd server
  "Run server"
  []
  []
  [{:keys [options]}]
  (sys/boot (read-config (:config options)))
  (cli/keep-alive))

(defcontainer root
  global-options
  server)

(defentrypoint -main
  root
  {:project-id "materia-core"})
