(ns materia.component.nrepl
  (:require [clojure.tools.nrepl.server :as nrepl]
            [com.stuartsierra.component :as c]
            [materia.logging :as log]
            [materia.util :as u]))

(def default-config {:enabled? true
                     :port 0
                     :bind "localhost"})

(defrecord Nrepl [conf]
  c/Lifecycle
  (start [this]
    (let [conf (merge default-config conf)]
      (if (:enabled? conf)
        (let [server (u/mapply nrepl/start-server (dissoc conf :enabled?))]
          (log/info "nREPL server is started on" (.toString (.getLocalSocketAddress (:ss server))))
          (assoc this
                 :server server))
        this)))
  (stop [this]
    (when-let [s (:server this)]
      (log/info "Shutting down nrepl server")
      (nrepl/stop-server s))
    (assoc this :server nil)))

(defn new-nrepl-server [conf]
  (map->Nrepl {:conf (:nrepl conf)}))
