(ns materia.preset.system
  (:require [com.stuartsierra.component :as c]
            [materia.component.auto-migrator :as amig]
            [materia.component.container :as container]
            [materia.component.db :as db]
            [materia.component.endpoint :as ep]
            [materia.component.migrator :as mig]
            [materia.component.nrepl :as nrepl]
            [materia.component.webserver :as web]))

(defn default-system [conf]
  {:db (db/new-database conf)
   :migrator (c/using (mig/new-migrator conf)
                      [:db])
   :auto-migrator (c/using
                   (amig/new-auto-migrator conf)
                   [:migrator])
   :sc (c/using
        (container/new-service-container conf)
        [:db])
   :ep (c/using
        (ep/new-endpoint conf)
        {:container :sc
         :db        :db})
   :webserver (c/using
               (web/new-webserver conf)
               {:handler :ep

                ;; Migrations should be performed before starting a
                ;; web server.
                :migrator :auto-migrator})
   :nrepl (nrepl/new-nrepl-server conf)})

(defn new-system [conf]
  (c/map->SystemMap (default-system conf)))

(defn new-db-system [conf]
  (c/map->SystemMap
   (select-keys (default-system conf) [:db])))

(defn new-migration-system [conf]
  (c/map->SystemMap
   (select-keys (default-system conf) [:db :migrator])))
