(defproject materia/materia-core "0.3.0-SNAPSHOT"
  :description "A collection of reusable components for Clojure web applications"
  :min-lein-version "2.5.1"
  :repl-options {:init-ns materia.repl}
  :dependencies [[org.clojure/clojure "_"]

                 ;; Web
                 [org.immutant/immutant "2.0.2"]
                 [ring/ring-defaults "0.1.5"]
                 [ring/ring-core "1.4.0"]
                 [ring/ring-devel "1.4.0"]
                 [metosin/ring-http-response "0.6.3"]
                 [bidi "1.20.1"]
                 [prone "0.8.2"]
                 [enlive "1.1.6"]

                 ;; Service management
                 [com.stuartsierra/component "0.2.3"]

                 ;; Logging
                 [spootnik/unilog "0.7.5"]
                 [org.clojure/tools.logging "0.3.1"]
                 [io.aviso/pretty "0.1.18"]

                 ;; DB
                 [mysql/mysql-connector-java "5.1.36"]
                 [funcool/clojure.jdbc "0.5.1"]
                 [hikari-cp "1.2.4" :exclusions [com.zaxxer/HikariCP]]
                 [com.zaxxer/HikariCP-java6 "2.3.9"]
                 [stch-library/sql "0.1.1"]
                 [clj-liquibase "0.5.2"]

                 ;; misc
                 [bultitude "0.2.7"]
                 [potemkin "0.4.1"]
                 [prismatic/plumbing "0.4.4"]
                 [org.clojure/tools.cli "0.3.1"]
                 [org.clojure/tools.namespace "0.2.11"]
                 [org.clojure/tools.nrepl "0.2.10"] ; https://github.com/technomancy/leiningen/issues/1748
                 [rkworks/baum "0.2.0"]
                 [environ "1.0.0"]
                 [clj-time "0.10.0"]
                 [inflections "0.9.14"]
                 [com.cemerick/url "0.1.1"]]
  :plugins [[lein-environ "1.0.0"]
            [lein-modules "0.3.11"]]
  :profiles {:uberjar {:aot :all}
             :dev {:dependencies [[commons-io "2.4"]
                                  [ring/ring-mock "0.2.0"]
                                  [clj-http "1.1.2"]
                                  [midje "1.7.0"]
                                  [com.h2database/h2 "1.4.187"]]
                   :plugins      [[lein-midje "3.1.3"]]
                   :env          {:dev true}}}
  :main materia.main)
