(ns materia.component.scheduler
  (:require [com.stuartsierra.component :as c]
            [immutant.scheduling :as s]
            [materia.logging :as log]))

(defprotocol IJob
  (handler [this])
  (spec [this]))

(defn job? [x]
  (satisfies? IJob x))

(defrecord Job [job-fn job-spec]
  IJob
  (handler [this] job-fn)
  (spec [this] job-spec))

(defn job [job-fn job-spec]
  (->Job job-fn job-spec))

(defprotocol IJobManager
  ;; TODO: more ops
  (stop-by-id [this id]))

(defrecord Scheduler []
  c/Lifecycle
  (start [this]
    (log/info "Starting scheduler")
    (->> (for [[k job] this
               :when (job? job)
               :let [id k]]
           [k (s/schedule (handler job) (s/id (spec job) id))])
         (into {})
         (assoc this ::jobs)))
  (stop [this]
    (log/info "Stopping scheduler" (::jobs this))
    (doseq [[_ job] (::jobs this)]
      (s/stop job))
    (assoc this ::jobs nil))

  IJobManager
  (stop-by-id [this id]
    (s/stop (s/id id))))
