(ns materia.preset.middleware
  (:require [materia.middleware
             [container :refer [wrap-service-container]]
             [db :refer [wrap-sql-logger wrap-with-connection-source]]
             [js-injector :refer [wrap-js-injector]]
             [reload :refer [wrap-reload]]
             [request :refer [wrap-request-binding wrap-request-logger wrap-pseudo-method]]
             [response :refer [wrap-error-handler]]
             [routing :refer [wrap-ignore-trailing-slash wrap-bidi-routing]]]
            [materia.middleware-set :as m]
            [prone.middleware :refer [wrap-exceptions]]
            [ring.middleware
             [defaults :refer [wrap-defaults]]
             [stacktrace :refer [wrap-stacktrace-web wrap-stacktrace-log]]]))

(defn- add-linearly [bag & ms]
  (m/add-linearly
   bag
   (reduce (fn [acc [tag f options]]
             (if (true? options)
               (conj acc (m/middleware tag f))
               (if options
                 (conj acc (m/middleware tag f options))
                 (conj acc (m/disabled-middleware tag f options)))))
           []
           ms)))

(defn middlewares [{:keys [request-logger
                           request-binding
                           auto-reload
                           prone sql-logger
                           inject-js
                           pseudo-method
                           stacktrace-log
                           stacktrace-web
                           routes
                           error-handler
                           service-container
                           connection-source]
                    :as conf}]
  (-> (m/middlewares)
      (add-linearly [:stacktrace-web wrap-stacktrace-web stacktrace-web]
                    [:stacktrace-log wrap-stacktrace-log stacktrace-log]
                    [:service-container wrap-service-container service-container]
                    [:connection-source wrap-with-connection-source connection-source]
                    [:prone wrap-exceptions prone]
                    [:error-handler wrap-error-handler error-handler]
                    [:ignore-trailing-slash wrap-ignore-trailing-slash true]
                    [:routes wrap-bidi-routing routes]
                    [:defaults wrap-defaults conf]
                    [:sql-logger wrap-sql-logger sql-logger]
                    [:auto-reload wrap-reload auto-reload]
                    [:pseudo-method wrap-pseudo-method pseudo-method]
                    [:request-binding wrap-request-binding request-binding]
                    [:request-logger wrap-request-logger request-logger]
                    [:js-injector wrap-js-injector inject-js])))
