(ns materia.middleware.request
  (:require [clojure.pprint :refer [pprint]]
            [clojure.string :as str]
            [materia.logging :as log]
            [materia.request :refer [*request*]]))

(defn wrap-request-binding [handler]
  (fn [req]
    (binding [*request* req]
      (handler req))))

(defn wrap-request-logger [handler]
  (fn [req]
    (log/info (with-out-str (pprint req)))
    (handler req)))

(defn wrap-pseudo-method [handler]
  (fn [req]
    (let [request-method (:request-method req)
          form-method    (or (get-in req [:form-params "_method"])
                             (get-in req [:multipart-params "_method"]))]
      (if (and form-method (= request-method :post))
        (handler (-> req
                     (assoc :request-method
                            (keyword (str/lower-case form-method)))
                     (assoc :original-request-method
                            request-method)))
        (handler req)))))
