(ns materia.util.test
  (:require [environ.core :refer [env]]
            [jdbc.core :as jdbc]
            [materia.config :as conf]
            [materia.db :as db]
            [materia.preset.system :refer [new-migration-system]]
            [materia.system :as sys]
            [materia.util.component :refer [with-component create-from-conf]]))

(defmacro with-env [m & body]
  `(with-redefs [env (merge env ~m)]
     ~@body))

(defmacro with-test-env [& body]
  `(with-env {:test true}
     ~@body))

(defn read-test-config-dwim [conf-or-path]
  (if (map? conf-or-path)
    conf-or-path
    (with-test-env (conf/read-config conf-or-path))))

(defn do-prepare [conf]
  (sys/prepare conf)
  conf)

(defmacro with-endpoint [[ep-sym conf-or-path] & body]
  `(with-component [s# (create-from-conf (do-prepare (read-test-config-dwim ~conf-or-path)))]
     (let [db# (:db s#)
           keep-alive-conn# (jdbc/connection db#)]
       (try
         (.migrate (:migrator s#))
         (db/with-connection-source db#
           (let [~ep-sym (get-in s# [:webserver :handler-fn])]
             ~@body))
         (finally
           (.close keep-alive-conn#))))))

(defmacro with-endpoint-tx [[ep-sym conf-or-path] & body]
  `(with-component [s# (create-from-conf (do-prepare (read-test-config-dwim ~conf-or-path)))]
     (let [db# (:db s#)]
       (db/with-connection-source db#
         (db/atomic
          (db/set-rollback!)
          (let [~ep-sym (get-in s# [:webserver :handler-fn])]
            (.migrate (:migrator s#))
            ~@body))))))

(defmacro with-test-db [conf-or-path & body]
  `(with-component [s# (new-migration-system (do-prepare (read-test-config-dwim ~conf-or-path)))]
     (let [db# (:db s#)
           keep-alive-conn# (jdbc/connection db#)]
       (try
         (.migrate (:migrator s#))
         (db/with-connection-source db#
           ~@body)
         (finally
           (.close keep-alive-conn#))))))

(defmacro with-test-db-tx [conf-or-path & body]
  `(with-component [s# (new-migration-system (do-prepare (read-test-config-dwim ~conf-or-path)))]
     (let [db# (:db s#)]
       (db/with-connection-source db#
         (db/atomic
          (db/set-rollback!)
          (.migrate (:migrator s#))
          ~@body)))))
