(ns materia.routing
  (:require [materia.handler :as h]
            [materia.response :as res]
            [ring.util.request :as req]
            [ronda.routing :as ronda]
            [ronda.routing.descriptor :as describe]))

(defn create-router []
  (let [get-handler (h/create-handler-resolver)]
    (fn router [req]
      (if-let [handler (get-handler (ronda/endpoint req))]
        (handler req)
        (res/not-found!)))))

(defn create-dynamic-router []
  (fn router [req]
    (let [get-handler (h/create-handler-resolver)]
      (if-let [handler (get-handler (ronda/endpoint req))]
        (handler req)
        (res/not-found!)))))

(defn- inherit-route-params [req values keys]
  (reduce
   (fn [values' key]
     (if-let [v (or (get-in req [:route-params key])
                    (get-in req [:params key]))]
       (assoc values' key v)
       values'))
   values
   keys))

(defn href
  "Generate path + query string for the given route. If `inherit-keys`
  is specified, inherit parameters corresponding to each key from
  current request path. For example, let current path is /foo/page/20
  and the route definition is /:context/page/:page, then you can
  generate new path as follows using the parameter inheritance:

  (href req :route-id {:page 21} [:context]) ; => /foo/page/21"
  ([req route-id]
   (href req route-id {}))
  ([req route-id values]
   (href req route-id values []))
  ([req route-id values inherit-keys]
   (str
    (:context req)
    (ronda/href req route-id (inherit-route-params req values inherit-keys)))))

(defn match-request
  "Same as `ronda.routing.descriptor/match-request` but matches
  against :path-info instead of :uri for servlet containers."
  [descriptor {:keys [request-method] :as request}]
  (describe/match descriptor request-method (req/path-info request)))
