(ns materia.util.component
  (:require [com.stuartsierra.component :as c]))

(defmacro with-component
  [[s ctor] & body]
  `(let [~s (c/start ~ctor)]
     (try
       ~@body
       (finally
         (c/stop ~s)))))

(defn create-from-conf [conf]
  (let [ctor (get-in conf [:system :ctor])]
    (ctor conf)))

(defn start-from-conf [conf]
  (c/start (create-from-conf conf)))
