(ns materia.logging
  (:require [io.aviso.logging :refer [install-pretty-logging
                                      install-uncaught-exception-handler]]
            [materia.util.namespace :refer [import-ns]]
            [unilog.config :as unilog]))

(defn start-logging! [conf]
  (let [default-logging {:level "info" :console true}]
    (unilog/start-logging! (merge default-logging conf))))

(start-logging! nil)

(import-ns clojure.tools.logging)
(install-pretty-logging)
(install-uncaught-exception-handler)
