(ns materia.preset.system
  (:require [com.stuartsierra.component :as c]
            [materia.component.auto-migrator :as amig]
            [materia.component.container :as container]
            [materia.component.db :as db]
            [materia.component.endpoint :as ep]
            [materia.component.migrator :as mig]
            [materia.component.webserver :as web]))

(defn new-system [conf]
  (c/system-map
   :db (db/new-database conf)
   :migrator (c/using (mig/new-migrator conf)
                      [:db])
   :auto-migrator (c/using
                   (amig/new-auto-migrator conf)
                   [:migrator])
   :sc (c/using
        (container/new-service-container conf)
        [:db])
   :ep (c/using
        (ep/new-endpoint conf)
        {:container :sc
         :db        :db})
   :webserver (c/using
               (web/new-webserver conf)
               {:handler :ep
                :migrator :migrator     ; Migrations should be
                                        ; performed before starting a
                                        ; web server.
                })))

(defn new-db-system [conf]
  (c/system-map
   :db (db/new-database conf)))

(defn new-migration-system [conf]
  (c/system-map
   :db (db/new-database conf)
   :migrator (c/using (mig/new-migrator conf)
                      [:db])))
