(ns materia.component.endpoint
  (:require [environ.core :refer [env]]
            [materia.component.container :as container]
            [materia.component.ring :as ring]
            [materia.logging :as log]
            [materia.middleware-set :as m]
            [materia.preset.middleware :as pm]
            [materia.routing :as routing]
            [materia.util :as u]))

(defrecord Endpoint [container router db conf]
  ring/RingHandler
  (get-handler [this]
    (let [m-conf       (cond-> (:middleware conf)
                         container (assoc :service-container container)
                         db (assoc :connection-source db))
          middlewares  (pm/middlewares m-conf)
          configurator (:middleware-configurator conf)
          middlewares  (if (ifn? configurator)
                         (configurator middlewares this)
                         middlewares)]
      (doseq [m (m/get-all middlewares)]
        (log/debug "Applying middleware:" m))
      (m/wrap middlewares router))))

(defn new-endpoint [conf]
  (map->Endpoint {:conf (get conf :endpoint)
                  :router (if (env :dev)
                            (routing/create-dynamic-router)
                            (routing/create-router))}))
