(ns materia.component.webserver
  (:require [com.stuartsierra.component :as c]
            [immutant.web :as web]
            [materia.component.ring :as ring]
            [materia.logging :as log]))

(def default-server-config {:port 9000})

(defn default-handler [req]
  {:status 200
   :headers {"Content-Type" "text/html"}
   :body "Running"})

(defn- get-handler-fn [handler]
  (assert (satisfies? ring/RingHandler handler))
  (ring/get-handler handler))

(defrecord Webserver [handler conf]
  c/Lifecycle
  (start [this]
    (let [handler-fn (get-handler-fn handler)
          conf       (merge default-server-config conf)]
      (log/infof "Starting web server on port: %d" (:port conf))
      (assoc this
             :server (web/run handler-fn conf)
             :handler-fn handler-fn)))
  (stop [this]
    (log/info "Shutting down web server.")
    (if (not (:server this))
      this
      (do
        (web/stop (:server this))
        (assoc this :server nil)))))

(defn new-webserver [conf]
  (map->Webserver {:handler default-handler
                   :conf (:webserver conf)}))
