(ns materia.middleware.reload
  (:require [materia.util.namespace :refer [find-ns-contains-tagged-var]]
            [ring.middleware.reload :as dep]))

(defn wrap-ns-reload [handler & [{:keys [ns-finder-fn]
                                  :or {:ns-finder-fn all-ns}}]]
  (fn [req]
    (doseq [ns (ns-finder-fn)]
      (require (ns-name ns) :reload))
    (handler req)))

(defn wrap-var-reload [handler & [options]]
  (wrap-ns-reload handler
                  {:ns-finder-fn
                   #(find-ns-contains-tagged-var [:materia/reload])}))

(defn wrap-reload [handler & [options]]
  (-> handler
      (dep/wrap-reload options)
      (wrap-var-reload options)))
