(ns materia.middleware.routing
  (:require [materia.routing :refer [match-request]]
            [ronda.routing :as ronda]
            [ronda.routing.bidi :as bidi]
            [ronda.routing.descriptor :as describe]
            [ronda.routing.request :as r]))

(defn- remove-trailing-slash [s]
  (if (and (string? s)
           (not= s "/")
           (.endsWith ^String s "/"))
    (apply str (butlast s))
    s))

(defn wrap-ignore-trailing-slash
  "Modifies the request uri before calling the handler. Removes a
  single trailing slash from the end of the uri if present."
  [handler]
  (fn [req]
    (handler (-> req
                 (update-in [:uri] remove-trailing-slash)
                 (update-in [:path-info] remove-trailing-slash)))))

(defn wrap-routing
  "Same as `ronda.routing.middleware/wrap-routing` but uses the
  modified version of `ronda.routing.descriptor/match-request`. "
  [handler descriptor
   & [{:keys [response?]
       :or {response? false}}]]
  (fn [request]
    (let [request' (r/set-descriptor request descriptor)]
      (if-let [{:keys [route-params] :as data} (match-request descriptor request)]
        (if-let [r (-> request'
                       (update-in [:route-params] (fnil merge {}) route-params)
                       (update-in [:params] (fnil merge {}) route-params)
                       (r/set-routing-data data)
                       (handler))]
          (if response?
            (-> r
                (r/set-descriptor descriptor)
                (r/set-routing-data data))
            r))
        (handler request')))))

(defn wrap-bidi-routing [handler routes]
  (let [routes' (if (var? routes) (deref routes) routes)]
    (wrap-routing handler (bidi/descriptor routes'))))
