(ns materia.system
  (:require [com.stuartsierra.component :as c]
            [materia.logging :as log]
            [materia.util.component :as uc]))

(defonce system nil)

(defn shutdown [sys-var]
  (alter-var-root
   sys-var
   (fn [s]
     (if s
       (c/stop s))
     nil)))

(defn boot
  ([conf]
   (boot conf #'system))
  ([conf sys-var]
   (alter-var-root
    sys-var
    (fn [old]
      (if (nil? old)
        (uc/start-from-conf conf)
        (do
          (log/warn "System is already running. Rebooting...")
          (c/stop sys-var)
          (uc/start-from-conf conf)))))))
