(ns materia.view
  (:require [net.cgrand.enlive-html :as html]))

(defmacro deflayout
  [layout-name source args & forms]
  `(def ~(vary-meta layout-name assoc :layout true :source source)
     (html/template ~source ~args ~@forms)))

(defmacro defsnippet
  [name source selector args & forms]
  `(def ~(vary-meta name assoc :snippet true)
     (html/snippet ~source ~selector ~args ~@forms)))

(defmacro defsnippets
  [source & specs]
  (let [xml-sym (gensym "xml")]
    `(let [~xml-sym (html/html-resource ~source)]
       ~@(for [[name selector args & forms] specs]
           `(def ~(vary-meta name assoc :snippet true) (html/snippet ~xml-sym ~selector ~args ~@forms))))))
