(ns materia.services.figwheel.service
  (:require [clojurescript-build.auto :as auto]
            [figwheel-sidecar.auto-builder :as fig-auto]
            [figwheel-sidecar.core :as fig]
            [materia.utils :as u]
            [puppetlabs.trapperkeeper.core :refer [defservice]]
            [puppetlabs.trapperkeeper.services :refer [service-context]]
            [taoensso.timbre :as log]))

(defn fix-cljsbuild-conf [conf]
  (update-in conf [:builds] (fn [bs]
                              (if (map? bs)
                                (map (fn [[k v]]
                                       (assoc v :id (name k))) bs)
                                bs))))

(defprotocol FigwheelService)

(defservice figwheel-service
  [[:ConfigService get-in-config]]
  (init [this context]
        (log/info "Initializing figwheel service")
        (-> context
            (assoc :server (atom nil))
            (assoc :builder (atom nil))))
  (start [this context]
         (when (get-in-config [:figwheel :enabled] false)
           (reset! (:server context)
                   (fig/start-server (get-in-config [:figwheel])))
           (reset! (:builder context)
                   (-> (u/get-in-project-with-profile :dev [:cljsbuild])
                       (assoc :figwheel-server @(:server context))
                       fix-cljsbuild-conf
                       fig-auto/autobuild*)))
         context)
  (stop [this context]
        (log/info "Shutting down figwheel service")
        (auto/stop-autobuild! @(:builder context))
        (fig/stop-server @(:server context))
        (dissoc context :builder)
        (dissoc context :server)
        context))
