(defproject materia/materia-core "0.1.0-SNAPSHOT"
  :description "A collection of reusable components for Clojure web applications"
  :clean-targets ^{:protect false} [:target-path "resources/public/js/dist"]
  :jvm-opts ["-server"]
  :min-lein-version "2.5.1"
  :repl-options {:init-ns materia.repl}
  :source-paths ["src" "src-cljs"]
  :dependencies [[org.clojure/clojure "1.6.0"]

                 ;; Web server
                 [http-kit "2.1.19"]
                 [clojurewerkz/gizmo "1.0.0-alpha4"]
                 [compojure "1.3.2"]
                 [ring/ring-defaults "0.1.4"]
                 [ring-refresh "0.1.1"]
                 [prone "0.8.1"]

                 ;; Service management
                 [puppetlabs/trapperkeeper "1.1.0"]

                 ;; Logging
                 [com.taoensso/timbre "3.4.0"]

                 ;; DB
                 [mysql/mysql-connector-java "5.1.34"]
                 [clojure.jdbc "0.4.0"]
                 [hikari-cp "1.1.1" :exclusions [com.zaxxer/HikariCP]]
                 [com.zaxxer/HikariCP-java6 "2.3.3"]
                 [stch-library/sql "0.1.1"]
                 [clj-liquibase "0.5.2"]

                 ;; cljs
                 [org.clojure/clojurescript "0.0-3058" :scope "provided"]
                 [figwheel "0.2.1-SNAPSHOT"]
                 [figwheel-sidecar "0.2.1-SNAPSHOT"]
                 [reagent "0.5.0"]
                 [com.cemerick/piggieback "0.1.5"]
                 [weasel "0.6.0"]

                 ;; misc
                 [org.clojure/tools.nrepl "0.2.7"] ; required because of leiningen's bug
                 [org.clojure/tools.namespace "0.2.10"]
                 [rkworks/baum "0.1.2"]
                 [robert/hooke "1.3.0"]
                 [environ "1.0.0"]
                 [clj-time "0.9.0"]
                 [inflections "0.9.13"]
                 [buddy "0.4.1"]
                 [formative "0.8.8"]]
  :plugins [[lein-environ "1.0.0"]
            [lein-cljsbuild "1.0.5"]
            [lein-modules "0.3.11"]]
  :cljsbuild {:builds {:app {:source-paths ["src-cljs" "src"]
                             :compiler {:output-to     "resources/public/js/dist/app.js"
                                        :output-dir    "resources/public/js/dist/out"
                                        :source-map    "resources/public/js/dist/app.js.map"
                                        :preamble      ["reagent/react.min.js"]
                                        :optimizations :none
                                        :pretty-print  true}}}}
  :profiles {:uberjar {:aot [materia.main]
                       :env {:production true}}

             :cljs ^:leaky {:hooks     [leiningen.cljsbuild]
                            :cljsbuild {:builds {:app
                                                 {:compiler
                                                  {:optimizations :advanced
                                                   :pretty-print false}}}}}

             :dev {:repl-options {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}
                   :dependencies [[clj-webdriver "0.6.1" :exclusions [org.clojure/core.cache]]
                                  [kerodon "0.5.0" :exclusions [enlive]]
                                  [ring-mock "0.1.5"]
                                  [ring/ring-devel "1.3.2"]
                                  [midje "1.6.3"]
                                  [puppetlabs/trapperkeeper "1.1.0" :classifier "test"]
                                  [puppetlabs/kitchensink "1.0.0" :classifier "test"]
                                  [com.h2database/h2 "1.4.186"]]
                   :plugins      [[lein-midje "3.1.3"]]
                   :env          {:dev true}}}
  :aliases {"tk" ["trampoline" "run" "--config" "resources/config/default/config.edn"]}
  :main materia.main)
