(ns materia.config
  (:require [clojure.java.io :as io]
            [materia.utils :as u]
            [baum.core :as b]
            [puppetlabs.kitchensink.core :refer [deep-merge-with-keys]]
            [puppetlabs.trapperkeeper.config :refer [config-file->map] :as tkc]))

(b/deflazyreader dev-reader [v opts]
  (@#'b/reduction (b/match-reader [(b/env-reader :dev)
                                   true  v
                                   :else nil])
                  opts))

(defmacro with-baum
  "Replace TrapperKeeper's config loader with baum."
  [& body]
  `(with-redefs [deep-merge-with-keys (fn [~'_ & vs#]
                                        (apply u/deep-merge vs#))
                 config-file->map (fn [file#]
                                    (b/read-config (io/file file#)
                                                   {:shorthand? true
                                                    :readers {~''dev? dev-reader}}))]
     ~@body))

(defn load-config
  "Load TrapperKeeper's config file with baum"
  [file]
  (with-baum
    (tkc/load-config file)))
