(ns materia.services.webserver.service
  (:require [materia.services.webserver.core :as core]
            [materia.services.webserver.proto :as proto]
            [puppetlabs.trapperkeeper.core :refer [defservice]]
            [puppetlabs.trapperkeeper.services :refer [service-context]]))

(defservice http-kit-service
  "Provides a Http Kit server as a service."
  proto/WebServerService
  [[:ConfigService get-in-config]]
  (init [this context]
        (core/init context))
  (start [this context]
         (core/start context (get-in-config [:webserver])))
  (stop [this context]
        (core/stop context))
  (set-handler [this handler]
               (let [context (service-context this)]
                 (core/set-handler! context handler)))
  (add-handler [this handler]
               (let [context (service-context this)]
                 (core/add-handler! context handler)))
  (add-handler [this handler base-path]
               (let [context (service-context this)]
                 (core/add-handler! context handler base-path))))
