(ns materia.cljs.injector
  (:require [clojure.java.io :as io]
            [clojure.string :as str]
            [net.cgrand.enlive-html :as html]))

(defn js-src [src]
  [:script {:type "text/javascript" :src src}])

(defn js-require [ns]
  [:script {:type "text/javascript"}
   (format "goog.require('%s')" ns)])

(defn inject-js [conf]
  (apply comp (concat (map (fn [src]
                             (html/prepend (html/html (js-src src))))
                           (get-in conf [:prepend :paths] []))
                      (map (fn [ns]
                             (html/prepend (html/html (js-require ns))))
                           (get-in conf [:prepend :requires] []))
                      (map (fn [src]
                             (html/append (html/html (js-src src))))
                           (get-in conf [:append :paths] []))
                      (map (fn [ns]
                             (html/append (html/html (js-require ns))))
                           (get-in conf [:append :requires] [])))))

(defn transform-html [body transformer]
  (html/emit* (html/transform (html/html-resource (cond
                                                    (string? body) (java.io.StringReader. body)
                                                    (seq? body) (java.io.StringReader. (str/join body))
                                                    :else body))
                              [:body] transformer)))

(defn wrap-js-injector [handler conf]
  (fn [req]
    (let [res (handler req)
          type (get-in res [:headers "Content-Type"] "text/html; charset=utf-8")]
      (if (re-find #"text/html" type)
        (update-in res [:body] transform-html (inject-js conf))
        res))))
