(ns web.routes.seasonal
  (:require
    [schema.core :as s]
    [ring.util.http-response :refer [ok]]
    [compojure.core :refer :all] ; [compojure.core :refer [defroutes routes]]
    [compojure.route :as route]
    [compojure.api.sweet :as sweet]
    [cheshire.core :refer :all]

    [seasonal.stats :refer [get-transformed-series get-series-stats-optimal] ]
    [seasonal.trading :as trading]
    [seasonal.job :refer [load-stats]]
  ))

(def seasonal-routes
  (sweet/context "/api/seasonal" [] :tags ["seasonal"]

    (sweet/GET "/calculation" []
        :query-params [{month :- s/Int 0}]
        (ok (if (= month 0)
                 (load-stats)
                 (load-stats month)
                 )))


      ;  (GET "/timeseries" [symbol] (generate-string (map #(dissoc % :date) (stats/get-transformed-series mongo/db  symbol))))
     (sweet/GET "/timeseries" []
         :query-params [symbol]
         (ok (get-transformed-series  symbol)))

     (sweet/GET "/series-stats" []
         :query-params [symbol :- s/Str ,
                        {year-start :- s/Int 0} {year-end :- s/Int 0}
                        {max-positions :- s/Int 1} {min-risk-reward :- s/Int 30}
                        {is-future :- s/Bool false}]
         (ok (let [p {:year-start year-start
                      :year-end year-end
                      :max-positions   max-positions
                      :min-risk-reward min-risk-reward
                      :is-future is-future}]
                (do (println "get-series-stats-optimal" "[" symbol "] params: " p)
                    (get-series-stats-optimal symbol p)))))

      (sweet/GET "/simulate-symbol" []
         :query-params [symbol :- s/Str ,
                       {year-start :- s/Int 0} {year-end :- s/Int 0}
                       {max-positions :- s/Int 1} {min-risk-reward :- s/Int 30}
                       {is-future :- s/Bool false}]
         (ok (trading/trade-symbol-cum-pl symbol {:year-start year-start
                                                  :year-end year-end
                                                  :max-positions   max-positions
                                                  :min-risk-reward min-risk-reward
                                                  :is-future is-future})))

       (sweet/GET "/simulate-portfolio" []
         :query-params [symbol :- s/Str ,
                       {year-start :- s/Int 0} {year-end :- s/Int 0}
                       {max-positions :- s/Int 1} {min-risk-reward :- s/Int 30}
                       {is-future :- s/Bool false}]
        (ok (trading/trade-list-cum-pl symbol {:year-start      year-start
                                               :year-end        year-end
                                               :max-positions   max-positions
                                               :min-risk-reward min-risk-reward
                                               :is-future       is-future }   )))

))
