(ns universe.index
  (:require
    [reagent.core :as r]
    [api.get :refer [get-data]]
    [comp.mui :as mui]
    [comp.mytab :as mytab]
    [comp.table :as table]
    [comp.input :as cinput]
    [comp.button :as cbutton]))

(def app-state
  (r/atom
    {
     :index-list [  ]
     :instrument nil
     :add-symbol ""
     }))

(defn update-index-list! [data]
      (r/rswap! app-state assoc :index-list data))

(defn get-index-list [category]
      (get-data :universe-index-category {:category category} #( do (update-index-list! %)
                                     ;(println "index-list received: " %)
                                     )))

(defn list-add [symbol]
  (get-data :portfolio-list-add {:symbol-portfolio (str symbol " List")} #(get-index-list "List")))


(defn href-index-details [instrument]
      (str "/#/indexdetail/" (:symbol instrument)))

(defn index-table [indices]
      [mui/paper
        [:h1 (str "Indices (" (count indices) ") " )]
        [table/my-table [[:COUNT_INDEX_MEMBERS "#"]
                         [:symbol "Symbol" nil href-index-details]
                         [:NAME "Name"]
                        ]
          indices]
      ])


(defn portfolio-page [category]
  (let [xx (get-index-list category)]
    (fn []
      (let [indices (:index-list @app-state)
            indices (sort-by :COUNT_INDEX_MEMBERS > indices) ; # IndexMembers DESC
           ]
         (index-table indices)
             ))
    ))

(defn list-page []
  (let [symbol-new-list (r/atom "")]
    [:div
       [cinput/atom-input symbol-new-list]
       [mui/button {:on-click #(list-add @symbol-new-list) } "Add List (don't add the extension List)"]
       [portfolio-page "List"]
     ]
    ))

(defn index-page []
      (portfolio-page "Index"))

(defn href-instrument-details [instrument]
      (str "/#/indexdetail/" (:symbol instrument)))
