(ns universe.bloomberg
  (:require
    [reagent.core :as r]
    [helper.reagent :refer [fetch-update]]
    [comp.mui :as mui]
    [comp.mytab :as mytab]
    [comp.table :as table]
    ))

(def app-state
  (r/atom {:result {:list []}}))

(defn run-search [searchq]
   (fetch-update app-state :list :bloomberg-search {:name searchq}))


(defn instrument-table
  [instruments]
  [mui/paper
     [:h1 (str "Found Instruments (" (count instruments) ") " )]
     [table/my-table [[:category "Category"]
                      [:symbol "Symbol"]
                      [:description "Description"]]
                     instruments]])

(defn search-menu []
  (let [searchq (r/atom "")]
    (fn []
      [:div
        [:input {:type "text"
                 :name "name"
                 :placeholder "Search for name"
                 :value @searchq
                 :on-change #(reset! searchq (-> % .-target .-value))}]
        [:input {:type "submit"
                 :value "search symbol"
                 :on-click #(run-search @searchq)}]])))


(defn search-page []
  (fn []
   (let [instruments (get-in @app-state [:result :list])]
    [:div
       [search-menu]
       [instrument-table instruments]])))
